/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.AlphaSender;

public class AlphaSenderFetcher
extends Fetcher<AlphaSender> {
    private final String pathServiceSid;
    private final String pathSid;

    public AlphaSenderFetcher(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    @Override
    public AlphaSender fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.MESSAGING.toString(), "/v1/Services/" + this.pathServiceSid + "/AlphaSenders/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AlphaSender fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AlphaSender.fromJson(response.getStream(), client.getObjectMapper());
    }
}

