/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.call.EventReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
extends Resource {
    private static final long serialVersionUID = 164982033524343L;
    private final String timestamp;
    private final String callSid;
    private final String accountSid;
    private final TwilioEdge edge;
    private final String group;
    private final Level level;
    private final String name;
    private final Map<String, Object> carrierEdge;
    private final Map<String, Object> sipEdge;
    private final Map<String, Object> sdkEdge;
    private final Map<String, Object> clientEdge;

    public static EventReader reader(String pathCallSid) {
        return new EventReader(pathCallSid);
    }

    public static Event fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Event)objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Event fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Event)objectMapper.readValue(json, Event.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Event(@JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="edge") TwilioEdge edge, @JsonProperty(value="group") String group, @JsonProperty(value="level") Level level, @JsonProperty(value="name") String name, @JsonProperty(value="carrier_edge") Map<String, Object> carrierEdge, @JsonProperty(value="sip_edge") Map<String, Object> sipEdge, @JsonProperty(value="sdk_edge") Map<String, Object> sdkEdge, @JsonProperty(value="client_edge") Map<String, Object> clientEdge) {
        this.timestamp = timestamp;
        this.callSid = callSid;
        this.accountSid = accountSid;
        this.edge = edge;
        this.group = group;
        this.level = level;
        this.name = name;
        this.carrierEdge = carrierEdge;
        this.sipEdge = sipEdge;
        this.sdkEdge = sdkEdge;
        this.clientEdge = clientEdge;
    }

    public final String getTimestamp() {
        return this.timestamp;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final TwilioEdge getEdge() {
        return this.edge;
    }

    public final String getGroup() {
        return this.group;
    }

    public final Level getLevel() {
        return this.level;
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, Object> getCarrierEdge() {
        return this.carrierEdge;
    }

    public final Map<String, Object> getSipEdge() {
        return this.sipEdge;
    }

    public final Map<String, Object> getSdkEdge() {
        return this.sdkEdge;
    }

    public final Map<String, Object> getClientEdge() {
        return this.clientEdge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event other = (Event)o;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals((Object)this.edge, (Object)other.edge) && Objects.equals(this.group, other.group) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.name, other.name) && Objects.equals(this.carrierEdge, other.carrierEdge) && Objects.equals(this.sipEdge, other.sipEdge) && Objects.equals(this.sdkEdge, other.sdkEdge) && Objects.equals(this.clientEdge, other.clientEdge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.callSid, this.accountSid, this.edge, this.group, this.level, this.name, this.carrierEdge, this.sipEdge, this.sdkEdge, this.clientEdge});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", (Object)this.timestamp).add("callSid", (Object)this.callSid).add("accountSid", (Object)this.accountSid).add("edge", (Object)this.edge).add("group", (Object)this.group).add("level", (Object)this.level).add("name", (Object)this.name).add("carrierEdge", this.carrierEdge).add("sipEdge", this.sipEdge).add("sdkEdge", this.sdkEdge).add("clientEdge", this.clientEdge).toString();
    }

    public static enum Level {
        UNKNOWN("UNKNOWN"),
        DEBUG("DEBUG"),
        INFO("INFO"),
        WARNING("WARNING"),
        ERROR("ERROR");

        private final String value;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Level forValue(String value) {
            return (Level)Promoter.enumFromString((String)value, (Enum[])Level.values());
        }
    }

    public static enum TwilioEdge {
        UNKNOWN_EDGE("unknown_edge"),
        CARRIER_EDGE("carrier_edge"),
        SIP_EDGE("sip_edge"),
        SDK_EDGE("sdk_edge"),
        CLIENT_EDGE("client_edge");

        private final String value;

        private TwilioEdge(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static TwilioEdge forValue(String value) {
            return (TwilioEdge)Promoter.enumFromString((String)value, (Enum[])TwilioEdge.values());
        }
    }
}

