/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.ChannelCreator;
import com.twilio.rest.flexapi.v1.ChannelDeleter;
import com.twilio.rest.flexapi.v1.ChannelFetcher;
import com.twilio.rest.flexapi.v1.ChannelReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Channel
extends Resource {
    private static final long serialVersionUID = 192292992411746L;
    private final String accountSid;
    private final String flexFlowSid;
    private final String sid;
    private final String userSid;
    private final String taskSid;
    private final URI url;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static ChannelReader reader() {
        return new ChannelReader();
    }

    public static ChannelFetcher fetcher(String pathSid) {
        return new ChannelFetcher(pathSid);
    }

    public static ChannelCreator creator(String flexFlowSid, String identity, String chatUserFriendlyName, String chatFriendlyName) {
        return new ChannelCreator(flexFlowSid, identity, chatUserFriendlyName, chatFriendlyName);
    }

    public static ChannelDeleter deleter(String pathSid) {
        return new ChannelDeleter(pathSid);
    }

    public static Channel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Channel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Channel)objectMapper.readValue(json, Channel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Channel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flex_flow_sid") String flexFlowSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="user_sid") String userSid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="url") URI url, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.accountSid = accountSid;
        this.flexFlowSid = flexFlowSid;
        this.sid = sid;
        this.userSid = userSid;
        this.taskSid = taskSid;
        this.url = url;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlexFlowSid() {
        return this.flexFlowSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUserSid() {
        return this.userSid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel other = (Channel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flexFlowSid, other.flexFlowSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.userSid, other.userSid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.url, other.url) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.flexFlowSid, this.sid, this.userSid, this.taskSid, this.url, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("flexFlowSid", (Object)this.flexFlowSid).add("sid", (Object)this.sid).add("userSid", (Object)this.userSid).add("taskSid", (Object)this.taskSid).add("url", (Object)this.url).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).toString();
    }
}

