/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.fax.v1.Fax;

public class FaxUpdater
extends Updater<Fax> {
    private final String pathSid;
    private Fax.UpdateStatus status;

    public FaxUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public FaxUpdater setStatus(Fax.UpdateStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public Fax update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.FAX.toString(), "/v1/Faxes/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fax update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Fax.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

