/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.conversation.ParticipantCreator;
import com.twilio.rest.conversations.v1.service.conversation.ParticipantDeleter;
import com.twilio.rest.conversations.v1.service.conversation.ParticipantFetcher;
import com.twilio.rest.conversations.v1.service.conversation.ParticipantReader;
import com.twilio.rest.conversations.v1.service.conversation.ParticipantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 61866669035230L;
    private final String accountSid;
    private final String chatServiceSid;
    private final String conversationSid;
    private final String sid;
    private final String identity;
    private final String attributes;
    private final Map<String, Object> messagingBinding;
    private final String roleSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static ParticipantCreator creator(String pathChatServiceSid, String pathConversationSid) {
        return new ParticipantCreator(pathChatServiceSid, pathConversationSid);
    }

    public static ParticipantUpdater updater(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new ParticipantUpdater(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static ParticipantDeleter deleter(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new ParticipantDeleter(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static ParticipantFetcher fetcher(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new ParticipantFetcher(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static ParticipantReader reader(String pathChatServiceSid, String pathConversationSid) {
        return new ParticipantReader(pathChatServiceSid, pathConversationSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Participant)objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="identity") String identity, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="messaging_binding") Map<String, Object> messagingBinding, @JsonProperty(value="role_sid") String roleSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.conversationSid = conversationSid;
        this.sid = sid;
        this.identity = identity;
        this.attributes = attributes;
        this.messagingBinding = messagingBinding;
        this.roleSid = roleSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final Map<String, Object> getMessagingBinding() {
        return this.messagingBinding;
    }

    public final String getRoleSid() {
        return this.roleSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.identity, other.identity) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.messagingBinding, other.messagingBinding) && Objects.equals(this.roleSid, other.roleSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.chatServiceSid, this.conversationSid, this.sid, this.identity, this.attributes, this.messagingBinding, this.roleSid, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("chatServiceSid", (Object)this.chatServiceSid).add("conversationSid", (Object)this.conversationSid).add("sid", (Object)this.sid).add("identity", (Object)this.identity).add("attributes", (Object)this.attributes).add("messagingBinding", this.messagingBinding).add("roleSid", (Object)this.roleSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

