/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.bulkexports.v1.export;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.bulkexports.v1.export.JobDeleter;
import com.twilio.rest.bulkexports.v1.export.JobFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Job
extends Resource {
    private static final long serialVersionUID = 26365801574783L;
    private final String resourceType;
    private final String friendlyName;
    private final Map<String, Object> details;
    private final String startDay;
    private final String endDay;
    private final String jobSid;
    private final String webhookUrl;
    private final String webhookMethod;
    private final String email;
    private final URI url;

    public static JobFetcher fetcher(String pathJobSid) {
        return new JobFetcher(pathJobSid);
    }

    public static JobDeleter deleter(String pathJobSid) {
        return new JobDeleter(pathJobSid);
    }

    public static Job fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Job)objectMapper.readValue(json, Job.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Job fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Job)objectMapper.readValue(json, Job.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Job(@JsonProperty(value="resource_type") String resourceType, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="details") Map<String, Object> details, @JsonProperty(value="start_day") String startDay, @JsonProperty(value="end_day") String endDay, @JsonProperty(value="job_sid") String jobSid, @JsonProperty(value="webhook_url") String webhookUrl, @JsonProperty(value="webhook_method") String webhookMethod, @JsonProperty(value="email") String email, @JsonProperty(value="url") URI url) {
        this.resourceType = resourceType;
        this.friendlyName = friendlyName;
        this.details = details;
        this.startDay = startDay;
        this.endDay = endDay;
        this.jobSid = jobSid;
        this.webhookUrl = webhookUrl;
        this.webhookMethod = webhookMethod;
        this.email = email;
        this.url = url;
    }

    public final String getResourceType() {
        return this.resourceType;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, Object> getDetails() {
        return this.details;
    }

    public final String getStartDay() {
        return this.startDay;
    }

    public final String getEndDay() {
        return this.endDay;
    }

    public final String getJobSid() {
        return this.jobSid;
    }

    public final String getWebhookUrl() {
        return this.webhookUrl;
    }

    public final String getWebhookMethod() {
        return this.webhookMethod;
    }

    public final String getEmail() {
        return this.email;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job other = (Job)o;
        return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.details, other.details) && Objects.equals(this.startDay, other.startDay) && Objects.equals(this.endDay, other.endDay) && Objects.equals(this.jobSid, other.jobSid) && Objects.equals(this.webhookUrl, other.webhookUrl) && Objects.equals(this.webhookMethod, other.webhookMethod) && Objects.equals(this.email, other.email) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.friendlyName, this.details, this.startDay, this.endDay, this.jobSid, this.webhookUrl, this.webhookMethod, this.email, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resourceType", (Object)this.resourceType).add("friendlyName", (Object)this.friendlyName).add("details", this.details).add("startDay", (Object)this.startDay).add("endDay", (Object)this.endDay).add("jobSid", (Object)this.jobSid).add("webhookUrl", (Object)this.webhookUrl).add("webhookMethod", (Object)this.webhookMethod).add("email", (Object)this.email).add("url", (Object)this.url).toString();
    }
}

