/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.incomingphonenumber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.api.v2010.account.incomingphonenumber.MobileCreator;
import com.twilio.rest.api.v2010.account.incomingphonenumber.MobileReader;
import com.twilio.type.PhoneNumber;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Mobile
extends Resource {
    private static final long serialVersionUID = 89458301105703L;
    private final String accountSid;
    private final String addressSid;
    private final AddressRequirement addressRequirements;
    private final String apiVersion;
    private final Boolean beta;
    private final PhoneNumberCapabilities capabilities;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String identitySid;
    private final PhoneNumber phoneNumber;
    private final String origin;
    private final String sid;
    private final String smsApplicationSid;
    private final HttpMethod smsFallbackMethod;
    private final URI smsFallbackUrl;
    private final HttpMethod smsMethod;
    private final URI smsUrl;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String trunkSid;
    private final String uri;
    private final VoiceReceiveMode voiceReceiveMode;
    private final String voiceApplicationSid;
    private final Boolean voiceCallerIdLookup;
    private final HttpMethod voiceFallbackMethod;
    private final URI voiceFallbackUrl;
    private final HttpMethod voiceMethod;
    private final URI voiceUrl;
    private final EmergencyStatus emergencyStatus;
    private final String emergencyAddressSid;
    private final String bundleSid;
    private final String status;

    public static MobileReader reader(String pathAccountSid) {
        return new MobileReader(pathAccountSid);
    }

    public static MobileReader reader() {
        return new MobileReader();
    }

    public static MobileCreator creator(String pathAccountSid, PhoneNumber phoneNumber) {
        return new MobileCreator(pathAccountSid, phoneNumber);
    }

    public static MobileCreator creator(PhoneNumber phoneNumber) {
        return new MobileCreator(phoneNumber);
    }

    public static Mobile fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Mobile)objectMapper.readValue(json, Mobile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Mobile fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Mobile)objectMapper.readValue(json, Mobile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Mobile(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="address_sid") String addressSid, @JsonProperty(value="address_requirements") AddressRequirement addressRequirements, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="beta") Boolean beta, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="identity_sid") String identitySid, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="origin") String origin, @JsonProperty(value="sid") String sid, @JsonProperty(value="sms_application_sid") String smsApplicationSid, @JsonProperty(value="sms_fallback_method") HttpMethod smsFallbackMethod, @JsonProperty(value="sms_fallback_url") URI smsFallbackUrl, @JsonProperty(value="sms_method") HttpMethod smsMethod, @JsonProperty(value="sms_url") URI smsUrl, @JsonProperty(value="status_callback") URI statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="uri") String uri, @JsonProperty(value="voice_receive_mode") VoiceReceiveMode voiceReceiveMode, @JsonProperty(value="voice_application_sid") String voiceApplicationSid, @JsonProperty(value="voice_caller_id_lookup") Boolean voiceCallerIdLookup, @JsonProperty(value="voice_fallback_method") HttpMethod voiceFallbackMethod, @JsonProperty(value="voice_fallback_url") URI voiceFallbackUrl, @JsonProperty(value="voice_method") HttpMethod voiceMethod, @JsonProperty(value="voice_url") URI voiceUrl, @JsonProperty(value="emergency_status") EmergencyStatus emergencyStatus, @JsonProperty(value="emergency_address_sid") String emergencyAddressSid, @JsonProperty(value="bundle_sid") String bundleSid, @JsonProperty(value="status") String status) {
        this.accountSid = accountSid;
        this.addressSid = addressSid;
        this.addressRequirements = addressRequirements;
        this.apiVersion = apiVersion;
        this.beta = beta;
        this.capabilities = capabilities;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.identitySid = identitySid;
        this.phoneNumber = phoneNumber;
        this.origin = origin;
        this.sid = sid;
        this.smsApplicationSid = smsApplicationSid;
        this.smsFallbackMethod = smsFallbackMethod;
        this.smsFallbackUrl = smsFallbackUrl;
        this.smsMethod = smsMethod;
        this.smsUrl = smsUrl;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.trunkSid = trunkSid;
        this.uri = uri;
        this.voiceReceiveMode = voiceReceiveMode;
        this.voiceApplicationSid = voiceApplicationSid;
        this.voiceCallerIdLookup = voiceCallerIdLookup;
        this.voiceFallbackMethod = voiceFallbackMethod;
        this.voiceFallbackUrl = voiceFallbackUrl;
        this.voiceMethod = voiceMethod;
        this.voiceUrl = voiceUrl;
        this.emergencyStatus = emergencyStatus;
        this.emergencyAddressSid = emergencyAddressSid;
        this.bundleSid = bundleSid;
        this.status = status;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAddressSid() {
        return this.addressSid;
    }

    public final AddressRequirement getAddressRequirements() {
        return this.addressRequirements;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final Boolean getBeta() {
        return this.beta;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIdentitySid() {
        return this.identitySid;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getOrigin() {
        return this.origin;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSmsApplicationSid() {
        return this.smsApplicationSid;
    }

    public final HttpMethod getSmsFallbackMethod() {
        return this.smsFallbackMethod;
    }

    public final URI getSmsFallbackUrl() {
        return this.smsFallbackUrl;
    }

    public final HttpMethod getSmsMethod() {
        return this.smsMethod;
    }

    public final URI getSmsUrl() {
        return this.smsUrl;
    }

    public final URI getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final String getUri() {
        return this.uri;
    }

    public final VoiceReceiveMode getVoiceReceiveMode() {
        return this.voiceReceiveMode;
    }

    public final String getVoiceApplicationSid() {
        return this.voiceApplicationSid;
    }

    public final Boolean getVoiceCallerIdLookup() {
        return this.voiceCallerIdLookup;
    }

    public final HttpMethod getVoiceFallbackMethod() {
        return this.voiceFallbackMethod;
    }

    public final URI getVoiceFallbackUrl() {
        return this.voiceFallbackUrl;
    }

    public final HttpMethod getVoiceMethod() {
        return this.voiceMethod;
    }

    public final URI getVoiceUrl() {
        return this.voiceUrl;
    }

    public final EmergencyStatus getEmergencyStatus() {
        return this.emergencyStatus;
    }

    public final String getEmergencyAddressSid() {
        return this.emergencyAddressSid;
    }

    public final String getBundleSid() {
        return this.bundleSid;
    }

    public final String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mobile other = (Mobile)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.addressSid, other.addressSid) && Objects.equals((Object)this.addressRequirements, (Object)other.addressRequirements) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.beta, other.beta) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.identitySid, other.identitySid) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.origin, other.origin) && Objects.equals(this.sid, other.sid) && Objects.equals(this.smsApplicationSid, other.smsApplicationSid) && Objects.equals((Object)this.smsFallbackMethod, (Object)other.smsFallbackMethod) && Objects.equals(this.smsFallbackUrl, other.smsFallbackUrl) && Objects.equals((Object)this.smsMethod, (Object)other.smsMethod) && Objects.equals(this.smsUrl, other.smsUrl) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.uri, other.uri) && Objects.equals((Object)this.voiceReceiveMode, (Object)other.voiceReceiveMode) && Objects.equals(this.voiceApplicationSid, other.voiceApplicationSid) && Objects.equals(this.voiceCallerIdLookup, other.voiceCallerIdLookup) && Objects.equals((Object)this.voiceFallbackMethod, (Object)other.voiceFallbackMethod) && Objects.equals(this.voiceFallbackUrl, other.voiceFallbackUrl) && Objects.equals((Object)this.voiceMethod, (Object)other.voiceMethod) && Objects.equals(this.voiceUrl, other.voiceUrl) && Objects.equals((Object)this.emergencyStatus, (Object)other.emergencyStatus) && Objects.equals(this.emergencyAddressSid, other.emergencyAddressSid) && Objects.equals(this.bundleSid, other.bundleSid) && Objects.equals(this.status, other.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.addressSid, this.addressRequirements, this.apiVersion, this.beta, this.capabilities, this.dateCreated, this.dateUpdated, this.friendlyName, this.identitySid, this.phoneNumber, this.origin, this.sid, this.smsApplicationSid, this.smsFallbackMethod, this.smsFallbackUrl, this.smsMethod, this.smsUrl, this.statusCallback, this.statusCallbackMethod, this.trunkSid, this.uri, this.voiceReceiveMode, this.voiceApplicationSid, this.voiceCallerIdLookup, this.voiceFallbackMethod, this.voiceFallbackUrl, this.voiceMethod, this.voiceUrl, this.emergencyStatus, this.emergencyAddressSid, this.bundleSid, this.status});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("addressSid", (Object)this.addressSid).add("addressRequirements", (Object)this.addressRequirements).add("apiVersion", (Object)this.apiVersion).add("beta", (Object)this.beta).add("capabilities", (Object)this.capabilities).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("identitySid", (Object)this.identitySid).add("phoneNumber", (Object)this.phoneNumber).add("origin", (Object)this.origin).add("sid", (Object)this.sid).add("smsApplicationSid", (Object)this.smsApplicationSid).add("smsFallbackMethod", (Object)this.smsFallbackMethod).add("smsFallbackUrl", (Object)this.smsFallbackUrl).add("smsMethod", (Object)this.smsMethod).add("smsUrl", (Object)this.smsUrl).add("statusCallback", (Object)this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("trunkSid", (Object)this.trunkSid).add("uri", (Object)this.uri).add("voiceReceiveMode", (Object)this.voiceReceiveMode).add("voiceApplicationSid", (Object)this.voiceApplicationSid).add("voiceCallerIdLookup", (Object)this.voiceCallerIdLookup).add("voiceFallbackMethod", (Object)this.voiceFallbackMethod).add("voiceFallbackUrl", (Object)this.voiceFallbackUrl).add("voiceMethod", (Object)this.voiceMethod).add("voiceUrl", (Object)this.voiceUrl).add("emergencyStatus", (Object)this.emergencyStatus).add("emergencyAddressSid", (Object)this.emergencyAddressSid).add("bundleSid", (Object)this.bundleSid).add("status", (Object)this.status).toString();
    }

    public static enum VoiceReceiveMode {
        VOICE("voice"),
        FAX("fax");

        private final String value;

        private VoiceReceiveMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static VoiceReceiveMode forValue(String value) {
            return (VoiceReceiveMode)Promoter.enumFromString((String)value, (Enum[])VoiceReceiveMode.values());
        }
    }

    public static enum EmergencyStatus {
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private final String value;

        private EmergencyStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EmergencyStatus forValue(String value) {
            return (EmergencyStatus)Promoter.enumFromString((String)value, (Enum[])EmergencyStatus.values());
        }
    }

    public static enum AddressRequirement {
        NONE("none"),
        ANY("any"),
        LOCAL("local"),
        FOREIGN("foreign");

        private final String value;

        private AddressRequirement(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRequirement forValue(String value) {
            return (AddressRequirement)Promoter.enumFromString((String)value, (Enum[])AddressRequirement.values());
        }
    }
}

