/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.CallCreator;
import com.twilio.rest.api.v2010.account.CallDeleter;
import com.twilio.rest.api.v2010.account.CallFetcher;
import com.twilio.rest.api.v2010.account.CallReader;
import com.twilio.rest.api.v2010.account.CallUpdater;
import com.twilio.type.Endpoint;
import com.twilio.type.Twiml;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Call
extends Resource {
    private static final long serialVersionUID = 145756659403056L;
    private final String sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String parentCallSid;
    private final String accountSid;
    private final String to;
    private final String toFormatted;
    private final String from;
    private final String fromFormatted;
    private final String phoneNumberSid;
    private final Status status;
    private final DateTime startTime;
    private final DateTime endTime;
    private final String duration;
    private final String price;
    private final Currency priceUnit;
    private final String direction;
    private final String answeredBy;
    private final String annotation;
    private final String apiVersion;
    private final String forwardedFrom;
    private final String groupSid;
    private final String callerName;
    private final String queueTime;
    private final String trunkSid;
    private final String uri;
    private final Map<String, String> subresourceUris;

    public static CallCreator creator(String pathAccountSid, Endpoint to, Endpoint from, URI url) {
        return new CallCreator(pathAccountSid, to, from, url);
    }

    public static CallCreator creator(Endpoint to, Endpoint from, URI url) {
        return new CallCreator(to, from, url);
    }

    public static CallCreator creator(String pathAccountSid, Endpoint to, Endpoint from, Twiml twiml) {
        return new CallCreator(pathAccountSid, to, from, twiml);
    }

    public static CallCreator creator(Endpoint to, Endpoint from, Twiml twiml) {
        return new CallCreator(to, from, twiml);
    }

    public static CallCreator creator(String pathAccountSid, Endpoint to, Endpoint from, String applicationSid) {
        return new CallCreator(pathAccountSid, to, from, applicationSid);
    }

    public static CallCreator creator(Endpoint to, Endpoint from, String applicationSid) {
        return new CallCreator(to, from, applicationSid);
    }

    public static CallDeleter deleter(String pathAccountSid, String pathSid) {
        return new CallDeleter(pathAccountSid, pathSid);
    }

    public static CallDeleter deleter(String pathSid) {
        return new CallDeleter(pathSid);
    }

    public static CallFetcher fetcher(String pathAccountSid, String pathSid) {
        return new CallFetcher(pathAccountSid, pathSid);
    }

    public static CallFetcher fetcher(String pathSid) {
        return new CallFetcher(pathSid);
    }

    public static CallReader reader(String pathAccountSid) {
        return new CallReader(pathAccountSid);
    }

    public static CallReader reader() {
        return new CallReader();
    }

    public static CallUpdater updater(String pathAccountSid, String pathSid) {
        return new CallUpdater(pathAccountSid, pathSid);
    }

    public static CallUpdater updater(String pathSid) {
        return new CallUpdater(pathSid);
    }

    public static Call fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Call)objectMapper.readValue(json, Call.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Call fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Call)objectMapper.readValue(json, Call.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Call(@JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="parent_call_sid") String parentCallSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="to") String to, @JsonProperty(value="to_formatted") String toFormatted, @JsonProperty(value="from") String from, @JsonProperty(value="from_formatted") String fromFormatted, @JsonProperty(value="phone_number_sid") String phoneNumberSid, @JsonProperty(value="status") Status status, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration") String duration, @JsonProperty(value="price") String price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="direction") String direction, @JsonProperty(value="answered_by") String answeredBy, @JsonProperty(value="annotation") String annotation, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="forwarded_from") String forwardedFrom, @JsonProperty(value="group_sid") String groupSid, @JsonProperty(value="caller_name") String callerName, @JsonProperty(value="queue_time") String queueTime, @JsonProperty(value="trunk_sid") String trunkSid, @JsonProperty(value="uri") String uri, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris) {
        this.sid = sid;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.parentCallSid = parentCallSid;
        this.accountSid = accountSid;
        this.to = to;
        this.toFormatted = toFormatted;
        this.from = from;
        this.fromFormatted = fromFormatted;
        this.phoneNumberSid = phoneNumberSid;
        this.status = status;
        this.startTime = DateConverter.rfc2822DateTimeFromString(startTime);
        this.endTime = DateConverter.rfc2822DateTimeFromString(endTime);
        this.duration = duration;
        this.price = price;
        this.priceUnit = priceUnit;
        this.direction = direction;
        this.answeredBy = answeredBy;
        this.annotation = annotation;
        this.apiVersion = apiVersion;
        this.forwardedFrom = forwardedFrom;
        this.groupSid = groupSid;
        this.callerName = callerName;
        this.queueTime = queueTime;
        this.trunkSid = trunkSid;
        this.uri = uri;
        this.subresourceUris = subresourceUris;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getParentCallSid() {
        return this.parentCallSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getToFormatted() {
        return this.toFormatted;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getFromFormatted() {
        return this.fromFormatted;
    }

    public final String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final String getDuration() {
        return this.duration;
    }

    public final String getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final String getDirection() {
        return this.direction;
    }

    public final String getAnsweredBy() {
        return this.answeredBy;
    }

    public final String getAnnotation() {
        return this.annotation;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getForwardedFrom() {
        return this.forwardedFrom;
    }

    public final String getGroupSid() {
        return this.groupSid;
    }

    public final String getCallerName() {
        return this.callerName;
    }

    public final String getQueueTime() {
        return this.queueTime;
    }

    public final String getTrunkSid() {
        return this.trunkSid;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call other = (Call)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.parentCallSid, other.parentCallSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.to, other.to) && Objects.equals(this.toFormatted, other.toFormatted) && Objects.equals(this.from, other.from) && Objects.equals(this.fromFormatted, other.fromFormatted) && Objects.equals(this.phoneNumberSid, other.phoneNumberSid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.direction, other.direction) && Objects.equals(this.answeredBy, other.answeredBy) && Objects.equals(this.annotation, other.annotation) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.forwardedFrom, other.forwardedFrom) && Objects.equals(this.groupSid, other.groupSid) && Objects.equals(this.callerName, other.callerName) && Objects.equals(this.queueTime, other.queueTime) && Objects.equals(this.trunkSid, other.trunkSid) && Objects.equals(this.uri, other.uri) && Objects.equals(this.subresourceUris, other.subresourceUris);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sid, this.dateCreated, this.dateUpdated, this.parentCallSid, this.accountSid, this.to, this.toFormatted, this.from, this.fromFormatted, this.phoneNumberSid, this.status, this.startTime, this.endTime, this.duration, this.price, this.priceUnit, this.direction, this.answeredBy, this.annotation, this.apiVersion, this.forwardedFrom, this.groupSid, this.callerName, this.queueTime, this.trunkSid, this.uri, this.subresourceUris});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("parentCallSid", (Object)this.parentCallSid).add("accountSid", (Object)this.accountSid).add("to", (Object)this.to).add("toFormatted", (Object)this.toFormatted).add("from", (Object)this.from).add("fromFormatted", (Object)this.fromFormatted).add("phoneNumberSid", (Object)this.phoneNumberSid).add("status", (Object)this.status).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("duration", (Object)this.duration).add("price", (Object)this.price).add("priceUnit", (Object)this.priceUnit).add("direction", (Object)this.direction).add("answeredBy", (Object)this.answeredBy).add("annotation", (Object)this.annotation).add("apiVersion", (Object)this.apiVersion).add("forwardedFrom", (Object)this.forwardedFrom).add("groupSid", (Object)this.groupSid).add("callerName", (Object)this.callerName).add("queueTime", (Object)this.queueTime).add("trunkSid", (Object)this.trunkSid).add("uri", (Object)this.uri).add("subresourceUris", this.subresourceUris).toString();
    }

    public static enum UpdateStatus {
        CANCELED("canceled"),
        COMPLETED("completed");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum Status {
        QUEUED("queued"),
        RINGING("ringing"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        BUSY("busy"),
        FAILED("failed"),
        NO_ANSWER("no-answer"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Event forValue(String value) {
            return (Event)Promoter.enumFromString((String)value, (Enum[])Event.values());
        }
    }
}

