/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Component;
import org.apache.camel.DynamicPollingConsumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.processor.PollDynamicAwareResolver;
import org.apache.camel.processor.ProcessorHelper;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.PollDynamicAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends BaseProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private PollDynamicAware dynamicAware;
    private volatile String scheme;
    private CamelContext camelContext;
    private ConsumerCache consumerCache;
    private HeadersMapFactory headersMapFactory;
    private String id;
    private String routeId;
    private String variableReceive;
    private AggregationStrategy aggregationStrategy;
    private final Expression expression;
    private final String uri;
    private long timeout;
    private boolean aggregateOnException;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;
    private boolean autoStartupComponents = true;
    private boolean allowOptimisedComponents = true;

    public PollEnricher(Expression expression, String uri, long timeout) {
        this.expression = expression;
        this.uri = uri;
        this.timeout = timeout;
    }

    public PollEnricher(String uri, long timeout) {
        this.expression = null;
        this.uri = uri;
        this.timeout = timeout;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public PollDynamicAware getDynamicAware() {
        return this.dynamicAware;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.consumerCache.getEndpointUtilizationStatistics();
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public boolean isAutoStartupComponents() {
        return this.autoStartupComponents;
    }

    public void setAutoStartupComponents(boolean autoStartupComponents) {
        this.autoStartupComponents = autoStartupComponents;
    }

    public boolean isAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange resourceExchange;
        PollingConsumer consumer;
        Endpoint endpoint;
        try {
            this.preCheckPoll(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during pre poll check", exchange, (Throwable)e));
            callback.done(true);
            return true;
        }
        Object recipient = null;
        Object staticUri = null;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            if (this.dynamicAware != null) {
                PollDynamicAware.DynamicAwareEntry entry;
                String originalUri = this.uri;
                String uri = PollEnricher.resolveUri(exchange, recipient);
                String scheme = PollEnricher.resolveScheme(exchange, uri);
                if (this.dynamicAware.getScheme().equals(scheme) && (entry = this.dynamicAware.prepare(exchange, uri, originalUri)) != null && (staticUri = this.dynamicAware.resolveStaticUri(exchange, entry)) != null && LOG.isDebugEnabled()) {
                    LOG.debug("Optimising poll via PollDynamicAware component: {} to use static uri: {}", (Object)scheme, (Object)URISupport.sanitizeUri((String)staticUri));
                }
            }
            Object targetRecipient = staticUri != null ? staticUri : recipient;
            if ((targetRecipient = PollEnricher.prepareRecipient(exchange, targetRecipient)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Poll dynamic evaluated as null so cannot poll from any endpoint");
                }
                callback.done(true);
                return true;
            }
            Endpoint existing = PollEnricher.getExistingEndpoint(exchange, targetRecipient);
            if (existing == null) {
                endpoint = PollEnricher.resolveEndpoint(exchange, targetRecipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            consumer = this.consumerCache.acquirePollingConsumer(endpoint);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e);
                }
            } else {
                exchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
        boolean bridgeErrorHandler = PollEnricher.isBridgeErrorHandler(consumer);
        DynamicPollingConsumer dynamicConsumer = null;
        if (consumer instanceof DynamicPollingConsumer) {
            DynamicPollingConsumer dyn;
            dynamicConsumer = dyn = (DynamicPollingConsumer)consumer;
        }
        try {
            if (this.timeout < 0L) {
                LOG.debug("Consumer receive: {}", (Object)consumer);
                resourceExchange = dynamicConsumer != null ? dynamicConsumer.receive(exchange) : consumer.receive();
            } else if (this.timeout == 0L) {
                LOG.debug("Consumer receiveNoWait: {}", (Object)consumer);
                resourceExchange = dynamicConsumer != null ? dynamicConsumer.receiveNoWait(exchange) : consumer.receiveNoWait();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)consumer);
                }
                Exchange exchange2 = resourceExchange = dynamicConsumer != null ? dynamicConsumer.receive(exchange, this.timeout) : consumer.receive(this.timeout);
            }
            if (resourceExchange == null) {
                LOG.debug("Consumer received no exchange");
            } else {
                LOG.debug("Consumer received: {}", (Object)resourceExchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error during poll", exchange, (Throwable)e));
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.consumerCache.releasePollingConsumer(endpoint, consumer);
            if (prototype) {
                ServiceHelper.stopAndShutdownService((Object)endpoint);
            }
        }
        Object redelivered = exchange.getIn().getHeader("CamelRedelivered");
        Object redeliveryCounter = exchange.getIn().getHeader("CamelRedeliveryCounter");
        Object redeliveryMaxCounter = exchange.getIn().getHeader("CamelRedeliveryMaxCounter");
        Exception cause = null;
        if (resourceExchange != null && bridgeErrorHandler) {
            cause = resourceExchange.getException();
        }
        Object originalBody = null;
        Map originalHeaders = null;
        if (this.variableReceive != null) {
            try {
                originalBody = exchange.getMessage().getBody();
                originalHeaders = this.headersMapFactory.newMap(exchange.getMessage().getHeaders());
            }
            catch (Exception throwable) {
                exchange.setException((Throwable)throwable);
                callback.done(true);
                return true;
            }
        }
        try {
            if (!this.isAggregateOnException() && resourceExchange != null && resourceExchange.isFailed()) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)resourceExchange);
            } else {
                PollEnricher.prepareResult(exchange);
                ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    if (ExchangeHelper.shouldSetVariableResult((Exchange)aggregatedExchange, (String)this.variableReceive)) {
                        ExchangeHelper.setVariableFromMessageBodyAndHeaders((Exchange)aggregatedExchange, (String)this.variableReceive, (Message)aggregatedExchange.getMessage());
                        aggregatedExchange.getMessage().setBody(originalBody);
                        aggregatedExchange.getMessage().setHeaders(originalHeaders);
                    }
                    ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.getExchangeExtension().handoverCompletions(exchange);
                    }
                }
            }
            if (cause != null) {
                exchange.setException((Throwable)cause);
                exchange.getExchangeExtension().setRedeliveryExhausted(false);
                if (redelivered != null) {
                    exchange.getMessage().setHeader("CamelRedelivered", redelivered);
                }
                if (redeliveryCounter != null) {
                    exchange.getMessage().setHeader("CamelRedeliveryCounter", redeliveryCounter);
                }
                if (redeliveryMaxCounter != null) {
                    exchange.getMessage().setHeader("CamelRedeliveryMaxCounter", redeliveryMaxCounter);
                }
            }
            exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)consumer.getEndpoint().getEndpointUri());
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, (Throwable)e));
            callback.done(true);
            return true;
        }
        callback.done(true);
        return true;
    }

    private static boolean isBridgeErrorHandler(PollingConsumer consumer) {
        DefaultConsumer defaultConsumer;
        ExceptionHandler handler;
        PollingConsumer delegate = consumer;
        if (consumer instanceof EventDrivenPollingConsumer) {
            EventDrivenPollingConsumer eventDrivenPollingConsumer = (EventDrivenPollingConsumer)consumer;
            delegate = eventDrivenPollingConsumer.getDelegateConsumer();
        }
        boolean bridgeErrorHandler = false;
        if (delegate instanceof DefaultConsumer && (handler = (defaultConsumer = (DefaultConsumer)delegate).getExceptionHandler()) instanceof BridgeExceptionHandlerToErrorHandler) {
            bridgeErrorHandler = true;
        }
        return bridgeErrorHandler;
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        return ProcessorHelper.prepareRecipient(exchange, recipient);
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(exchange, recipient);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint((Exchange)exchange, (Object)recipient) : ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    public String toString() {
        return this.id;
    }

    protected static String resolveUri(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        String uri;
        if (recipient == null) {
            return null;
        }
        if (recipient instanceof String) {
            String string = (String)recipient;
            uri = string.trim();
        } else if (recipient instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)recipient;
            uri = endpoint.getEndpointKey();
        } else {
            uri = (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
        }
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)exchange.getContext(), (String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    protected static String resolveScheme(Exchange exchange, String uri) {
        return ExchangeHelper.resolveScheme((String)uri);
    }

    protected void doBuild() throws Exception {
        if (this.consumerCache == null) {
            this.consumerCache = new DefaultConsumerCache((Object)this, this.camelContext, this.cacheSize);
            LOG.debug("PollEnrich {} using ConsumerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
        }
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = new CopyAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.aggregationStrategy, (CamelContext)this.camelContext);
        ServiceHelper.buildService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy});
    }

    protected void doInit() throws Exception {
        block8: {
            if (this.expression != null) {
                this.expression.init(this.camelContext);
            }
            if (this.isAutoStartupComponents() && this.uri != null) {
                String u = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)this.uri);
                this.scheme = ExchangeHelper.resolveScheme((String)u);
            }
            if (this.isAllowOptimisedComponents() && this.uri != null) {
                try {
                    if (this.scheme != null) {
                        String defaultScheme;
                        Component comp;
                        PollDynamicAwareResolver resolver = new PollDynamicAwareResolver();
                        this.dynamicAware = resolver.resolve(this.camelContext, this.scheme);
                        if (this.dynamicAware == null && (comp = this.camelContext.getComponent(this.scheme, false, this.isAutoStartupComponents())) != null && !this.scheme.equals(defaultScheme = comp.getDefaultName())) {
                            this.dynamicAware = resolver.resolve(this.camelContext, defaultScheme);
                            this.dynamicAware.setScheme(this.scheme);
                        }
                        if (this.dynamicAware != null && LOG.isDebugEnabled()) {
                            LOG.debug("Detected PollDynamicAware component: {} optimising poll: {}", (Object)this.scheme, (Object)URISupport.sanitizeUri((String)this.uri));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("Error creating optimised PollDynamicAwareResolver for uri: {} due to {}. This exception is ignored", new Object[]{URISupport.sanitizeUri((String)this.uri), e.getMessage(), e});
                }
            }
        }
        this.headersMapFactory = this.camelContext.getCamelContextExtension().getHeadersMapFactory();
        ServiceHelper.initService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy, this.dynamicAware});
    }

    protected void doStart() throws Exception {
        if (this.autoStartupComponents && this.scheme != null) {
            this.camelContext.getComponent(this.scheme);
        }
        ServiceHelper.startService((Object[])new Object[]{this.consumerCache, this.aggregationStrategy, this.dynamicAware});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.aggregationStrategy, this.consumerCache, this.dynamicAware});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.aggregationStrategy, this.consumerCache});
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)oldExchange, (Exchange)newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

