/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.Map;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="java-security", description="Displays Java Security (JSSE) information")
@Configurer(extended=true)
public class JavaSecurityDevConsole
extends AbstractDevConsole {
    public JavaSecurityDevConsole() {
        super("jvm", "java-security", "Java Security", "Displays Java Security (JSSE) information");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Provider[] providers = Security.getProviders();
        if (providers != null && providers.length > 0) {
            sb.append("Security Providers:");
            sb.append("\n");
            for (Provider p : providers) {
                sb.append(String.format("\n    %s (%s)\n", p.getName(), p.getVersionStr()));
                if (p.getInfo() != null) {
                    sb.append(String.format("\n        %s\n", p.getInfo()));
                }
                List services = p.getServices().stream().sorted(JavaSecurityDevConsole::compare).toList();
                for (Provider.Service s : services) {
                    sb.append(String.format("\n        %s: %s (%s)", s.getType(), s.getAlgorithm(), s.getClassName()));
                }
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        Provider[] providers = Security.getProviders();
        if (providers != null && providers.length > 0) {
            JsonArray arr = new JsonArray();
            root.put((Object)"securityProviders", (Object)arr);
            for (Provider p : providers) {
                List services;
                JsonObject jo = new JsonObject();
                arr.add((Object)jo);
                jo.put((Object)"name", (Object)p.getName());
                jo.put((Object)"version", (Object)p.getVersionStr());
                if (p.getInfo() != null) {
                    jo.put((Object)"info", (Object)p.getInfo());
                }
                if ((services = p.getServices().stream().sorted(JavaSecurityDevConsole::compare).toList()).isEmpty()) continue;
                JsonArray arr2 = new JsonArray();
                jo.put((Object)"services", (Object)arr2);
                for (Provider.Service s : services) {
                    JsonObject js = new JsonObject();
                    js.put((Object)"type", (Object)s.getType());
                    js.put((Object)"algorithm", (Object)s.getAlgorithm());
                    js.put((Object)"className", (Object)s.getClassName());
                    arr2.add((Object)js);
                }
            }
        }
        return root;
    }

    private static int compare(Provider.Service o1, Provider.Service o2) {
        int num = o1.getType().compareToIgnoreCase(o2.getType());
        if (num == 0) {
            num = o1.getAlgorithm().compareToIgnoreCase(o2.getAlgorithm());
        }
        return num;
    }
}

