/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurerResolver
implements ConfigurerResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurerResolver.class);
    protected FactoryFinder factoryFinder;

    public DefaultConfigurerResolver() {
    }

    public DefaultConfigurerResolver(FactoryFinder factoryFinder) {
        this.factoryFinder = factoryFinder;
    }

    public PropertyConfigurer resolvePropertyConfigurer(String name, CamelContext context) {
        Class<?> type;
        if (ObjectHelper.isEmpty((String)name)) {
            return null;
        }
        PropertyConfigurer configurer = (PropertyConfigurer)context.getRegistry().lookupByNameAndType(name, PropertyConfigurer.class);
        if (configurer != null) {
            return configurer;
        }
        if (name.endsWith("-configurer")) {
            name = name.substring(0, name.length() - 11);
        }
        try {
            if (name.startsWith("org.apache.camel.") && name.contains("CamelContext") && !name.contains("Extension")) {
                Class<?> extensionType;
                type = this.findConfigurer(CamelContext.class.getName(), context);
                if (type != null && (extensionType = this.findConfigurer(ExtendedCamelContext.class.getName(), context)) != null) {
                    return this.createPropertyConfigurerForContext(name, context, type, extensionType);
                }
            } else {
                type = this.findConfigurer(name, context);
                if (type == null) {
                    return null;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Configurer registered for scheme: " + name, e);
        }
        return this.createPropertyConfigurer(name, context, type);
    }

    private PropertyConfigurer createPropertyConfigurer(String name, CamelContext context, Class<?> type) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found configurer: {} via type: {} via: {}{}", new Object[]{name, type.getName(), this.factoryFinder.getResourcePath(), name});
        }
        if (PropertyConfigurer.class.isAssignableFrom(type)) {
            return (PropertyConfigurer)context.getInjector().newInstance(type, false);
        }
        throw new IllegalArgumentException("Type is not a PropertyConfigurer implementation. Found: " + type.getName());
    }

    private PropertyConfigurer createPropertyConfigurerForContext(String name, CamelContext context, Class<?> type, Class<?> extensionType) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found configurer: {} via type: {} via: {}{}", new Object[]{name, type.getName(), this.factoryFinder.getResourcePath(), name});
        }
        PropertyConfigurer contextConfigurer = (PropertyConfigurer)context.getInjector().newInstance(type, false);
        PropertyConfigurer extensionConfigurer = (PropertyConfigurer)context.getInjector().newInstance(extensionType, false);
        if (PropertyConfigurer.class.isAssignableFrom(type)) {
            return new ContextConfigurer(contextConfigurer, extensionConfigurer);
        }
        throw new IllegalArgumentException("Type is not a PropertyConfigurer implementation. Found: " + type.getName());
    }

    private Class<?> findConfigurer(String name, CamelContext context) {
        if (this.factoryFinder == null) {
            this.factoryFinder = context.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/configurer/");
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }

    protected Logger getLog() {
        return LOG;
    }

    public static class ContextConfigurer
    implements PropertyConfigurer {
        private final PropertyConfigurer contextConfigurer;
        private final PropertyConfigurer extensionConfigurer;

        public ContextConfigurer(PropertyConfigurer contextConfigurer, PropertyConfigurer extensionConfigurer) {
            this.contextConfigurer = contextConfigurer;
            this.extensionConfigurer = extensionConfigurer;
        }

        public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
            CamelContext contextTarget;
            if (target instanceof CamelContext && !this.contextConfigurer.configure(camelContext, (Object)(contextTarget = (CamelContext)target), name, value, ignoreCase)) {
                return this.extensionConfigurer.configure(camelContext, (Object)contextTarget.getCamelContextExtension(), name, value, ignoreCase);
            }
            return false;
        }
    }
}

