/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.client.impl.RegistryClientImpl;
import io.apicurio.registry.rest.client.request.provider.AdminRequestsProvider;
import io.apicurio.registry.rest.v2.beans.ArtifactTypeInfo;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminClientImpl
implements AdminClient {
    private final ApicurioHttpClient apicurioHttpClient;
    private static final Logger logger = LoggerFactory.getLogger(RegistryClientImpl.class);

    public AdminClientImpl(ApicurioHttpClient apicurioHttpClient) {
        this.apicurioHttpClient = apicurioHttpClient;
    }

    @Override
    public void createGlobalRule(Rule data) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.createGlobalRule(data));
        }
        catch (JsonProcessingException e) {
            throw AdminClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public List<RuleType> listGlobalRules() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listGlobalRules());
    }

    @Override
    public void deleteGlobalRule(RuleType rule) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteGlobalRule(rule));
    }

    @Override
    public void deleteAllGlobalRules() {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteAllGlobalRules());
    }

    @Override
    public Rule getGlobalRuleConfig(RuleType rule) {
        return (Rule)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getGlobalRule(rule));
    }

    @Override
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        try {
            return (Rule)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.updateGlobalRuleConfig(rule, data));
        }
        catch (JsonProcessingException e) {
            throw AdminClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public NamedLogConfiguration setLogConfiguration(String logger, LogConfiguration data) {
        try {
            return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.setLogConfiguration(logger, data));
        }
        catch (JsonProcessingException e) {
            throw AdminClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public NamedLogConfiguration getLogConfiguration(String logger) {
        return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getLogConfiguration(logger));
    }

    @Override
    public List<NamedLogConfiguration> listLogConfigurations() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listLogConfigurations());
    }

    @Override
    public NamedLogConfiguration removeLogConfiguration(String logger) {
        return (NamedLogConfiguration)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.removeLogConfiguration(logger));
    }

    @Override
    public void createRoleMapping(RoleMapping data) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.createRoleMapping(data));
        }
        catch (JsonProcessingException e) {
            throw AdminClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public RoleMapping getRoleMapping(String principalId) {
        return (RoleMapping)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.getRoleMapping(principalId));
    }

    @Override
    public List<RoleMapping> listRoleMappings() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listRoleMappings());
    }

    @Override
    public void updateRoleMapping(String principalId, RoleType role) {
        try {
            this.apicurioHttpClient.sendRequest(AdminRequestsProvider.updateRoleMapping(principalId, role));
        }
        catch (JsonProcessingException e) {
            throw AdminClientImpl.parseSerializationError(e);
        }
    }

    @Override
    public void deleteRoleMapping(String principalId) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.deleteRoleMapping(principalId));
    }

    @Override
    public InputStream exportData() {
        return (InputStream)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.exportData());
    }

    @Override
    public void importData(InputStream data) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.importData(data, true, true));
    }

    @Override
    public void importData(InputStream data, boolean preserveGlobalIds, boolean preserveContentIds) {
        this.apicurioHttpClient.sendRequest(AdminRequestsProvider.importData(data, preserveGlobalIds, preserveContentIds));
    }

    @Override
    public List<ArtifactTypeInfo> listArtifactTypes() {
        return (List)this.apicurioHttpClient.sendRequest(AdminRequestsProvider.listArtifactTypes());
    }

    private static RestClientException parseSerializationError(JsonProcessingException ex) {
        Error error = new Error();
        error.setName(((Object)((Object)ex)).getClass().getSimpleName());
        error.setMessage(ex.getMessage());
        logger.debug("Error serializing request response", (Throwable)ex);
        return new RestClientException(error);
    }

    @Override
    public void close() {
        this.apicurioHttpClient.close();
    }
}

