/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client;

import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.impl.AdminClientImpl;
import io.apicurio.registry.rest.client.impl.ErrorHandler;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AdminClientFactory {
    private static final Map<String, String> KEYS_TO_TRANSLATE;
    public static final String BASE_PATH = "apis/registry/v2/";

    public static AdminClient create(String basePath) {
        return AdminClientFactory.create(basePath, Collections.emptyMap(), null);
    }

    public static AdminClient create(String baseUrl, Map<String, Object> configs, Auth auth) {
        if (configs.isEmpty()) {
            configs = Map.of("apicurio.registry.rest.client.auto-base-path", BASE_PATH);
        } else if (!configs.containsKey("apicurio.registry.rest.client.auto-base-path")) {
            configs.put("apicurio.registry.rest.client.auto-base-path", BASE_PATH);
        }
        Map<String, Object> processedConfigs = AdminClientFactory.processConfiguration(configs);
        return new AdminClientImpl(ApicurioHttpClientFactory.create((String)baseUrl, processedConfigs, (Auth)auth, (RestClientErrorHandler)new ErrorHandler()));
    }

    private static Map<String, Object> processConfiguration(Map<String, Object> configs) {
        HashMap<String, Object> processedConfigs = new HashMap<String, Object>();
        configs.forEach((key, value) -> processedConfigs.put(KEYS_TO_TRANSLATE.getOrDefault(key, (String)key), value));
        return processedConfigs;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("apicurio.registry.request.headers.", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.location", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.type", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.truststore.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.location", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.type", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.keystore.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.request.ssl.key.password", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.client.disable-auto-basepath-append", "apicurio.rest.request.headers.");
        map.put("apicurio.registry.rest.client.auto-base-path", "apicurio.rest.client.auto-base-path");
        KEYS_TO_TRANSLATE = Collections.unmodifiableMap(map);
    }
}

