/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.InlineKeyboardMarkup;
import org.apache.camel.component.telegram.model.OutgoingMessage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EditMessageReplyMarkupMessage
extends OutgoingMessage {
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;

    public EditMessageReplyMarkupMessage(String chatId, Integer messageId, String inlineMessageId, InlineKeyboardMarkup replyMarkup) {
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.replyMarkup = replyMarkup;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        return "EditMessageReplyMarkupMessage{messageId=" + this.messageId + ", inlineMessageId='" + this.inlineMessageId + "', replyMarkup=" + String.valueOf(this.replyMarkup) + ", chatId='" + this.chatId + "'}";
    }

    public static final class Builder {
        protected String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private InlineKeyboardMarkup replyMarkup;

        public Builder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        public Builder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public Builder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        public EditMessageReplyMarkupMessage build() {
            return new EditMessageReplyMarkupMessage(this.chatId, this.messageId, this.inlineMessageId, this.replyMarkup);
        }
    }
}

