/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeProperty;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.util.ObjectHelper;

public class ValueToKey {
    public void process(@ExchangeProperty(value="fields") String fields, Exchange ex) throws InvalidPayloadException {
        ArrayList<String> splittedFields = new ArrayList();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNodeBody = (JsonNode)ex.getMessage().getBody(JsonNode.class);
        Map body = (Map)mapper.convertValue((Object)jsonNodeBody, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        if (ObjectHelper.isNotEmpty((String)fields)) {
            splittedFields = Arrays.stream(fields.split(",")).collect(Collectors.toList());
        }
        HashMap key = new HashMap();
        for (Map.Entry entry : body.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (!this.filterNames(fieldName, splittedFields)) continue;
            Object fieldValue = entry.getValue();
            key.put(entry.getKey(), fieldValue);
        }
        ex.getMessage().setHeader("kafka.KEY", key);
    }

    boolean filterNames(String fieldName, List<String> splittedFields) {
        return splittedFields.contains(fieldName);
    }
}

