/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.kafkaconnector.CamelConnectorConfig;
import org.apache.camel.kafkaconnector.CamelSourceTask;
import org.apache.kafka.common.config.ConfigDef;

public class CamelSourceConnectorConfig
extends CamelConnectorConfig {
    public static final String CAMEL_SOURCE_UNMARSHAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_UNMARSHAL_CONF = "camel.source.unmarshal";
    public static final String CAMEL_SOURCE_UNMARSHAL_DOC = "The camel dataformat name to use to unmarshal data from the source";
    public static final String CAMEL_SOURCE_MARSHAL_DEFAULT = null;
    public static final String CAMEL_SOURCE_MARSHAL_CONF = "camel.source.marshal";
    public static final String CAMEL_SOURCE_MARSHAL_DOC = "The camel dataformat name to use to unmarshal data to the topic";
    public static final String CAMEL_SOURCE_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_URL_CONF = "camel.source.url";
    public static final String CAMEL_SOURCE_COMPONENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_COMPONENT_CONF = "camel.source.component";
    public static final String CAMEL_SOURCE_COMPONENT_DOC = "The camel component to use. This is normally set by default for you. It is ignored if camel.source.url is set.";
    public static final String CAMEL_SOURCE_URL_DOC = "The camel url to configure the source. If this is set camel.source.component and all the properties starting with " + CamelSourceTask.getCamelSourceEndpointConfigPrefix() + ".<camel.source.component value> are ignored.";
    public static final String TOPIC_DEFAULT = "test";
    public static final String TOPIC_CONF = "topics";
    public static final String TOPIC_DOC = "A list of topics to use as output for this connector";
    public static final Long CAMEL_SOURCE_MAX_BATCH_POLL_SIZE_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_MAX_BATCH_POLL_SIZE_CONF = "camel.source.maxBatchPollSize";
    public static final String CAMEL_SOURCE_MAX_BATCH_POLL_SIZE_DOC = "The max number of messages retrieved in a single poll()";
    public static final Long CAMEL_SOURCE_MAX_POLL_DURATION_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_MAX_POLL_DURATION_CONF = "camel.source.maxPollDuration";
    public static final String CAMEL_SOURCE_MAX_POLL_DURATION_DOC = "The maximum time in milliseconds spent in a single call to poll()";
    public static final Integer CAMEL_SOURCE_MAX_NOT_COMMITTED_RECORDS_DEFAULT = 1024;
    public static final String CAMEL_SOURCE_MAX_NOT_COMMITTED_RECORDS_CONF = "camel.source.maxNotCommittedRecords";
    public static final String CAMEL_SOURCE_MAX_NOT_COMMITTED_RECORDS_DOC = "The maximum number of non committed kafka connect records that can be tolerated before stop polling new records (rounded to the next power of 2) with a minimum of 4.";
    public static final Long CAMEL_SOURCE_POLLING_CONSUMER_QUEUE_SIZE_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_QUEUE_SIZE_CONF = "camel.source.pollingConsumerQueueSize";
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_QUEUE_SIZE_DOC = "The queue size for the internal hand-off queue between the polling consumer, and producers sending data into the queue.";
    public static final Long CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_TIMEOUT_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_TIMEOUT_CONF = "camel.source.pollingConsumerBlockTimeout";
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_TIMEOUT_DOC = "To use a timeout (in milliseconds) when the producer is blocked if the internal queue is full. If the value is 0 or negative then no timeout is in use.";
    public static final Boolean CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_WHEN_FULL_DEFAULT = true;
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_WHEN_FULL_CONF = "camel.source.pollingConsumerBlockWhenFull";
    public static final String CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_WHEN_FULL_DOC = "Whether to block any producer if the internal queue is full.";
    public static final String CAMEL_SOURCE_MESSAGE_HEADER_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MESSAGE_HEADER_KEY_CONF = "camel.source.camelMessageHeaderKey";
    public static final String CAMEL_SOURCE_MESSAGE_HEADER_KEY_DOC = "The name of a camel message header containing an unique key that can be used as a Kafka message key. If this is not specified, then the Kafka message will not have a key.";
    public static final String CAMEL_SOURCE_CONTENT_LOG_LEVEL_DEFAULT = LoggingLevel.OFF.toString();
    public static final String CAMEL_SOURCE_CONTENT_LOG_LEVEL_CONF = "camel.source.contentLogLevel";
    public static final String CAMEL_SOURCE_CONTENT_LOG_LEVEL_DOC = "Log level for the record's content (default: " + CAMEL_SOURCE_CONTENT_LOG_LEVEL_DEFAULT + "). Valid values: TRACE, DEBUG, INFO, WARN, ERROR, OFF.";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("camel.source.url", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_URL_DOC).define("camel.source.unmarshal", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_UNMARSHAL_DEFAULT, ConfigDef.Importance.HIGH, "The camel dataformat name to use to unmarshal data from the source").define("camel.source.marshal", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_MARSHAL_DEFAULT, ConfigDef.Importance.HIGH, "The camel dataformat name to use to unmarshal data to the topic").define("topics", ConfigDef.Type.STRING, (Object)"test", ConfigDef.Importance.HIGH, "A list of topics to use as output for this connector").define("camel.source.maxBatchPollSize", ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_MAX_BATCH_POLL_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, "The max number of messages retrieved in a single poll()").define("camel.source.maxPollDuration", ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_MAX_POLL_DURATION_DEFAULT, ConfigDef.Importance.MEDIUM, "The maximum time in milliseconds spent in a single call to poll()").define("camel.source.maxNotCommittedRecords", ConfigDef.Type.INT, (Object)CAMEL_SOURCE_MAX_NOT_COMMITTED_RECORDS_DEFAULT, ConfigDef.Importance.MEDIUM, "The maximum number of non committed kafka connect records that can be tolerated before stop polling new records (rounded to the next power of 2) with a minimum of 4.").define("camel.source.pollingConsumerQueueSize", ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_POLLING_CONSUMER_QUEUE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, "The queue size for the internal hand-off queue between the polling consumer, and producers sending data into the queue.").define("camel.source.pollingConsumerBlockTimeout", ConfigDef.Type.LONG, (Object)CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a timeout (in milliseconds) when the producer is blocked if the internal queue is full. If the value is 0 or negative then no timeout is in use.").define("camel.source.pollingConsumerBlockWhenFull", ConfigDef.Type.BOOLEAN, (Object)CAMEL_SOURCE_POLLING_CONSUMER_BLOCK_WHEN_FULL_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether to block any producer if the internal queue is full.").define("camel.source.camelMessageHeaderKey", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_MESSAGE_HEADER_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, "The name of a camel message header containing an unique key that can be used as a Kafka message key. If this is not specified, then the Kafka message will not have a key.").define("camel.source.component", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_COMPONENT_DEFAULT, ConfigDef.Importance.MEDIUM, "The camel component to use. This is normally set by default for you. It is ignored if camel.source.url is set.").define("camel.source.contentLogLevel", ConfigDef.Type.STRING, (Object)CAMEL_SOURCE_CONTENT_LOG_LEVEL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_CONTENT_LOG_LEVEL_DOC).define("camel.beans.aggregate", ConfigDef.Type.STRING, (Object)CAMEL_CONNECTOR_AGGREGATE_DEFAULT, ConfigDef.Importance.MEDIUM, "A reference to an aggregate bean, in the form of #class:").define("camel.aggregation.size", ConfigDef.Type.INT, (Object)CAMEL_CONNECTOR_AGGREGATE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, "The size of the aggregation, to be used in combination with camel.beans.aggregate").define("camel.aggregation.timeout", ConfigDef.Type.LONG, (Object)CAMEL_CONNECTOR_AGGREGATE_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, "The timeout of the aggregation, to be used in combination with camel.beans.aggregate").define("camel.error.handler", ConfigDef.Type.STRING, (Object)"default", ConfigDef.Importance.LOW, "The error handler to use: possible value are 'no' or 'default'").define("camel.error.handler.max.redeliveries", ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.MEDIUM, "The maximum redeliveries to be use in case of Default Error Handler").define("camel.error.handler.redelivery.delay", ConfigDef.Type.LONG, (Object)CAMEL_CONNECTOR_ERROR_HANDLER_REDELIVERY_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, "The initial redelivery delay in milliseconds in case of Default Error Handler").define("camel.idempotency.enabled", ConfigDef.Type.BOOLEAN, (Object)CAMEL_CONNECTOR_IDEMPOTENCY_ENABLED_DEFAULT, ConfigDef.Importance.LOW, "If idempotency must be enabled or not").define("camel.idempotency.expression.type", ConfigDef.Type.STRING, (Object)"body", ConfigDef.Importance.LOW, "How the idempotency will be evaluated: possible values are body and header").define("camel.idempotency.expression.header", ConfigDef.Type.STRING, (Object)CAMEL_CONNECTOR_IDEMPOTENCY_EXPRESSION_HEADER_DEFAULT, ConfigDef.Importance.LOW, "The header name that will be evaluated in case of camel.idempotency.expression.type equals to header").define("camel.idempotency.memory.dimension", ConfigDef.Type.INT, (Object)100, ConfigDef.Importance.LOW, "The Memory dimension of the in memory idempotent Repository").define("camel.idempotency.repository.type", ConfigDef.Type.STRING, (Object)"memory", ConfigDef.Importance.LOW, "The idempotent repository type to use, possible values are memory and kafka").define("camel.idempotency.kafka.topic", ConfigDef.Type.STRING, (Object)"kafka_idempotent_repository", ConfigDef.Importance.LOW, "The Kafka topic name to use for the idempotent repository").define("camel.idempotency.kafka.bootstrap.servers", ConfigDef.Type.STRING, (Object)"localhost:9092", ConfigDef.Importance.LOW, "A comma-separated list of host and port pairs that are the addresses of the Kafka brokers where the idempotent repository should live").define("camel.idempotency.kafka.max.cache.size", ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, "Sets the maximum size of the local key cache").define("camel.idempotency.kafka.poll.duration.ms", ConfigDef.Type.INT, (Object)100, ConfigDef.Importance.LOW, "Sets the poll duration (in milliseconds) of the Kafka consumer").define("camel.remove.headers.pattern", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The pattern of the headers we want to exclude from the exchange").define("camel.map.properties", ConfigDef.Type.BOOLEAN, (Object)CAMEL_CONNECTOR_MAP_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, "If set to true, the connector will transform the exchange properties into kafka headers.").define("camel.map.headers", ConfigDef.Type.BOOLEAN, (Object)CAMEL_CONNECTOR_MAP_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, "If set to true, the connector will transform the camel exchange headers into kafka headers.");

    public CamelSourceConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(CONFIG_DEF, parsedConfig);
    }

    public static ConfigDef conf() {
        return CONFIG_DEF;
    }
}

