/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConcurrentUtil {
    public static <T> T get(CompletableFuture<T> cf) {
        return ConcurrentUtil.get(cf, 0L, null);
    }

    public static <T> T get(CompletableFuture<T> cf, long duration, TimeUnit unit) {
        boolean interrupted = false;
        while (true) {
            try {
                T t = duration <= 0L ? cf.get() : cf.get(duration, unit);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException | TimeoutException e) {
                Throwable t = e.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(e);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T result(CompletionStage<T> stage) {
        return ConcurrentUtil.get(stage.toCompletableFuture());
    }

    public static <T, R> Function<T, R> function(Function<T, R> function) {
        return function;
    }

    public static <T> Consumer<T> consumer(Consumer<T> consumer) {
        return consumer;
    }

    @FunctionalInterface
    public static interface Consumer<T>
    extends java.util.function.Consumer<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        default public void accept(T t) {
            boolean interrupted = false;
            while (true) {
                try {
                    this.acceptInterruptibly(t);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        public void acceptInterruptibly(T var1) throws InterruptedException;
    }

    @FunctionalInterface
    public static interface Function<T, R>
    extends java.util.function.Function<T, R> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        default public R apply(T t) {
            boolean interrupted = false;
            while (true) {
                try {
                    R r = this.applyInterruptibly(t);
                    return r;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        public R applyInterruptibly(T var1) throws InterruptedException;
    }
}

