/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class DefaultLSResourceResolver
implements LSResourceResolver {
    private final CamelContext camelContext;
    private final String resourceUri;
    private final String resourcePath;
    private String relatedURI;
    private Map<String, String> relatedURIMap = new HashMap<String, String>();

    public DefaultLSResourceResolver(CamelContext camelContext, String resourceUri) {
        this.camelContext = camelContext;
        this.resourceUri = resourceUri;
        this.resourcePath = FileUtil.onlyPath((String)resourceUri);
    }

    private String getUri(String systemId) {
        if (this.resourcePath != null && !systemId.toLowerCase().startsWith("http:") && !systemId.toLowerCase().startsWith("https:")) {
            return FileUtil.onlyPath((String)this.resourceUri) + "/" + systemId;
        }
        return systemId;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Resource: %s refers an invalid resource without SystemId. Invalid resource has type: %s, namespaceURI: %s, publicId: %s, systemId: %s, baseURI: %s", this.resourceUri, type, namespaceURI, publicId, systemId, baseURI));
        }
        String resourceURI = null;
        if (baseURI == null) {
            resourceURI = this.relatedURI = FileUtil.compactPath((String)this.getUri(systemId), (char)'/');
        } else {
            String relatedPath = this.relatedURIMap.get(baseURI);
            if (relatedPath == null) {
                relatedPath = FileUtil.onlyPath((String)this.relatedURI);
                if (relatedPath == null) {
                    relatedPath = "";
                }
                resourceURI = this.relatedURI = FileUtil.compactPath((String)(FileUtil.onlyPath((String)this.relatedURI) + "/" + systemId), (char)'/');
                this.relatedURIMap.put(baseURI, relatedPath);
            } else {
                this.relatedURI = resourceURI = FileUtil.compactPath((String)(relatedPath + "/" + systemId), (char)'/');
            }
        }
        return new DefaultLSInput(publicId, systemId, baseURI, resourceURI);
    }

    private final class DefaultLSInput
    implements LSInput {
        private final String publicId;
        private final String systemId;
        private final String baseURI;
        private final String relatedURI;
        private final String uri;

        private DefaultLSInput(String publicId, String systemId, String basedURI, String relatedURI) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = basedURI;
            this.relatedURI = relatedURI;
            this.uri = this.getInputUri();
        }

        private String getInputUri() {
            if (ObjectHelper.isNotEmpty((String)this.relatedURI)) {
                try {
                    InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)DefaultLSResourceResolver.this.camelContext, (String)this.relatedURI);
                    IOHelper.close((Closeable)is);
                    return this.relatedURI;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return DefaultLSResourceResolver.this.getUri(this.systemId);
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader reader) {
        }

        @Override
        public InputStream getByteStream() {
            try {
                return ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)DefaultLSResourceResolver.this.camelContext, (String)this.uri);
            }
            catch (IOException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }

        @Override
        public void setByteStream(InputStream inputStream) {
        }

        @Override
        public String getStringData() {
            InputStream is = this.getByteStream();
            return (String)DefaultLSResourceResolver.this.camelContext.getTypeConverter().convertTo(String.class, (Object)is);
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        public String toString() {
            return "DefaultLSInput[" + this.uri + "]";
        }
    }
}

