/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;

@YamlType(inline=false, types={FromDefinition.class}, order=0, properties={@YamlProperty(name="uri", type="string", required=true), @YamlProperty(name="variableReceive", type="string"), @YamlProperty(name="id", type="string"), @YamlProperty(name="description", type="string"), @YamlProperty(name="parameters", type="object"), @YamlProperty(name="steps", type="array:org.apache.camel.model.ProcessorDefinition", required=true)})
public class FromDefinitionDeserializer
implements ConstructNode {
    public Object construct(Node node) {
        String uri;
        RouteDefinition route;
        int line = -1;
        if (node.getStartMark().isPresent()) {
            line = ((Mark)node.getStartMark().get()).getLine();
        }
        String desc = null;
        String id = null;
        String variableReceive = null;
        if (node.getNodeType() == NodeType.MAPPING) {
            MappingNode mn = (MappingNode)node;
            for (NodeTuple tuple : mn.getValue()) {
                String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
                if ("uri".equals(key)) {
                    if (!tuple.getKeyNode().getStartMark().isPresent()) continue;
                    line = ((Mark)tuple.getKeyNode().getStartMark().get()).getLine() + 1;
                    continue;
                }
                if ("description".equals(key)) {
                    desc = YamlDeserializerSupport.asText((Node)tuple.getValueNode());
                    continue;
                }
                if ("id".equals(key)) {
                    id = YamlDeserializerSupport.asText((Node)tuple.getValueNode());
                    continue;
                }
                if (!"variableReceive".equals(key)) continue;
                variableReceive = YamlDeserializerSupport.asText((Node)tuple.getValueNode());
            }
        }
        if ((route = (RouteDefinition)node.getProperty(RouteDefinition.class.getName())) == null) {
            route = new RouteDefinition();
        }
        if ((uri = YamlSupport.creteEndpointUri((Node)node, (RouteDefinition)route)) == null) {
            throw new IllegalStateException("The endpoint URI must be set");
        }
        FromDefinition target = new FromDefinition(uri);
        route.setInput(target);
        if (desc != null) {
            target.setDescription(desc);
        }
        if (id != null) {
            target.setId(id);
        }
        if (variableReceive != null) {
            target.setVariableReceive(variableReceive);
        }
        if (line != -1) {
            target.setLineNumber(line);
            YamlDeserializationContext ctx = YamlDeserializerSupport.getDeserializationContext((Node)node);
            if (ctx != null) {
                target.setLocation(ctx.getResource().getLocation());
            }
        }
        return target;
    }
}

