/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import java.util.Collections;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramConsumer;
import org.apache.camel.component.telegram.TelegramProducer;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.TelegramWebhookProcessor;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.component.telegram.service.TelegramServiceRestBotAPIAdapter;
import org.apache.camel.component.telegram.util.TelegramMessageHelper;
import org.apache.camel.component.webhook.WebhookCapableEndpoint;
import org.apache.camel.component.webhook.WebhookConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.proxy.ProxyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="telegram", title="Telegram", syntax="telegram:type", category={Category.CLOUD, Category.API, Category.CHAT})
public class TelegramEndpoint
extends ScheduledPollEndpoint
implements WebhookCapableEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramEndpoint.class);
    @UriParam
    private TelegramConfiguration configuration;
    @UriParam(label="advanced")
    private AsyncHttpClientConfig clientConfig;
    @UriParam(label="advanced", defaultValue="4096")
    private int bufferSize = 4096;
    private WebhookConfiguration webhookConfiguration;
    private AsyncHttpClient client;
    private TelegramService telegramService;

    public TelegramEndpoint(String endpointUri, Component component, TelegramConfiguration configuration, AsyncHttpClient client, AsyncHttpClientConfig clientConfig) {
        super(endpointUri, component);
        this.configuration = configuration;
        this.client = client;
        this.clientConfig = clientConfig;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            DefaultAsyncHttpClientConfig.Builder builder;
            DefaultAsyncHttpClientConfig.Builder builder2 = builder = this.clientConfig != null ? new DefaultAsyncHttpClientConfig.Builder(this.clientConfig) : new DefaultAsyncHttpClientConfig.Builder();
            if (this.configuration != null && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
                LOG.debug("Setup http proxy host:{} port:{} for TelegramService", (Object)this.configuration.getProxyHost(), (Object)this.configuration.getProxyPort());
                builder.setProxyServer(new ProxyServer.Builder(this.configuration.getProxyHost(), this.configuration.getProxyPort().intValue()).build());
            }
            DefaultAsyncHttpClientConfig config = builder.build();
            this.client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)config);
        }
        if (this.telegramService == null) {
            this.telegramService = new TelegramServiceRestBotAPIAdapter(this.client, this.bufferSize, this.configuration.getBaseUri(), this.configuration.getAuthorizationToken());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null && !this.client.isClosed()) {
            this.client.close();
        }
        this.client = null;
    }

    public Producer createProducer() throws Exception {
        return new TelegramProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TelegramConsumer consumer = new TelegramConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Update update) {
        Exchange exchange = super.createExchange();
        TelegramMessageHelper.populateExchange(exchange, update);
        return exchange;
    }

    public Processor createWebhookHandler(Processor next) {
        return new TelegramWebhookProcessor(next);
    }

    public void registerWebhook() throws Exception {
        if (!this.telegramService.setWebhook(this.webhookConfiguration.computeFullExternalUrl())) {
            throw new RuntimeCamelException("The Telegram API refused to register a webhook");
        }
    }

    public void unregisterWebhook() throws Exception {
        if (!this.telegramService.removeWebhook()) {
            throw new RuntimeCamelException("The Telegram API refused to unregister the webhook");
        }
    }

    public WebhookConfiguration getWebhookConfiguration() {
        return this.webhookConfiguration;
    }

    public void setWebhookConfiguration(WebhookConfiguration webhookConfiguration) {
        this.webhookConfiguration = webhookConfiguration;
    }

    public List<String> getWebhookMethods() {
        return Collections.singletonList("POST");
    }

    public TelegramConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TelegramConfiguration configuration) {
        this.configuration = configuration;
    }

    public TelegramService getTelegramService() {
        return this.telegramService;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

