/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.ReplyMarkup;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutgoingTextMessage
extends OutgoingMessage {
    private static final long serialVersionUID = -8684079202025229263L;
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="reply_markup")
    private ReplyMarkup replyMarkup;

    public OutgoingTextMessage() {
    }

    public OutgoingTextMessage(String text, String parseMode, Boolean disableWebPagePreview, ReplyMarkup replyMarkup) {
        this.text = text;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public void setReplyMarkup(ReplyMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String text;
        private String parseMode;
        private Boolean disableWebPagePreview;
        private ReplyMarkup replyMarkup;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public Builder disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public Builder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public OutgoingTextMessage build() {
            return new OutgoingTextMessage(this.text, this.parseMode, this.disableWebPagePreview, this.replyMarkup);
        }
    }
}

