/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NamedNode;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.apache.camel.util.concurrent.SizedScheduledExecutorService;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseExecutorServiceManager
extends ServiceSupport
implements ExecutorServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(BaseExecutorServiceManager.class);
    private final CamelContext camelContext;
    private final List<ExecutorService> executorServices = new CopyOnWriteArrayList<ExecutorService>();
    private final Map<String, ThreadPoolProfile> threadPoolProfiles = new ConcurrentHashMap<String, ThreadPoolProfile>();
    private ThreadPoolFactory threadPoolFactory;
    private String threadNamePattern;
    private long shutdownAwaitTermination = 10000L;
    private String defaultThreadPoolProfileId = "defaultThreadPoolProfile";
    private final ThreadPoolProfile defaultProfile;

    public BaseExecutorServiceManager(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.defaultProfile = new ThreadPoolProfile(this.defaultThreadPoolProfileId);
        this.defaultProfile.setDefaultProfile(Boolean.valueOf(true));
        this.defaultProfile.setPoolSize(Integer.valueOf(10));
        this.defaultProfile.setMaxPoolSize(Integer.valueOf(20));
        this.defaultProfile.setKeepAliveTime(Long.valueOf(60L));
        this.defaultProfile.setTimeUnit(TimeUnit.SECONDS);
        this.defaultProfile.setMaxQueueSize(Integer.valueOf(1000));
        this.defaultProfile.setAllowCoreThreadTimeOut(Boolean.valueOf(true));
        this.defaultProfile.setRejectedPolicy(ThreadPoolRejectedPolicy.CallerRuns);
        this.registerThreadPoolProfile(this.defaultProfile);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public ThreadPoolFactory getThreadPoolFactory() {
        return this.threadPoolFactory;
    }

    public void setThreadPoolFactory(ThreadPoolFactory threadPoolFactory) {
        this.threadPoolFactory = threadPoolFactory;
    }

    public void registerThreadPoolProfile(ThreadPoolProfile profile) {
        ObjectHelper.notNull((Object)profile, (String)"profile");
        StringHelper.notEmpty((String)profile.getId(), (String)"id", (Object)profile);
        this.threadPoolProfiles.put(profile.getId(), profile);
    }

    public ThreadPoolProfile getThreadPoolProfile(String id) {
        return this.threadPoolProfiles.get(id);
    }

    public ThreadPoolProfile getDefaultThreadPoolProfile() {
        return this.getThreadPoolProfile(this.defaultThreadPoolProfileId);
    }

    public void setDefaultThreadPoolProfile(ThreadPoolProfile defaultThreadPoolProfile) {
        this.threadPoolProfiles.remove(this.defaultThreadPoolProfileId);
        defaultThreadPoolProfile.addDefaults(this.defaultProfile);
        LOG.info("Using custom DefaultThreadPoolProfile: {}", (Object)defaultThreadPoolProfile);
        this.defaultThreadPoolProfileId = defaultThreadPoolProfile.getId();
        defaultThreadPoolProfile.setDefaultProfile(Boolean.valueOf(true));
        this.registerThreadPoolProfile(defaultThreadPoolProfile);
    }

    public String getThreadNamePattern() {
        return this.threadNamePattern;
    }

    public void setThreadNamePattern(String threadNamePattern) {
        this.threadNamePattern = threadNamePattern != null ? threadNamePattern.replace("#camelId#", this.camelContext.getName()) : threadNamePattern;
    }

    public long getShutdownAwaitTermination() {
        return this.shutdownAwaitTermination;
    }

    public void setShutdownAwaitTermination(long shutdownAwaitTermination) {
        this.shutdownAwaitTermination = shutdownAwaitTermination;
    }

    public String resolveThreadName(String name) {
        return ThreadHelper.resolveThreadName((String)this.threadNamePattern, (String)name);
    }

    public Thread newThread(String name, Runnable runnable) {
        ThreadFactory factory = this.createThreadFactory(name, true);
        return factory.newThread(runnable);
    }

    public ExecutorService newDefaultThreadPool(Object source, String name) {
        return this.newThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    public ScheduledExecutorService newDefaultScheduledThreadPool(Object source, String name) {
        return this.newScheduledThreadPool(source, name, this.getDefaultThreadPoolProfile());
    }

    public ExecutorService newThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newThreadPool(source, name, profile);
        }
        return null;
    }

    public ExecutorService newThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri((String)name);
        ObjectHelper.notNull((Object)profile, (String)"ThreadPoolProfile");
        ThreadPoolProfile defaultProfile = this.getDefaultThreadPoolProfile();
        profile.addDefaults(defaultProfile);
        ThreadFactory threadFactory = this.createThreadFactory(sanitizedName, true);
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(profile, threadFactory);
        this.onThreadPoolCreated(executorService, source, profile.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, executorService});
        }
        return executorService;
    }

    public ExecutorService newThreadPool(Object source, String name, int poolSize, int maxPoolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(Integer.valueOf(poolSize));
        profile.setMaxPoolSize(Integer.valueOf(maxPoolSize));
        return this.newThreadPool(source, name, profile);
    }

    public ExecutorService newSingleThreadExecutor(Object source, String name) {
        return this.newFixedThreadPool(source, name, 1);
    }

    public ExecutorService newCachedThreadPool(Object source, String name) {
        String sanitizedName = URISupport.sanitizeUri((String)name);
        ExecutorService answer = this.threadPoolFactory.newCachedThreadPool(this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new CachedThreadPool for source: {} with name: {}. -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    public ExecutorService newFixedThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(Integer.valueOf(poolSize));
        profile.setMaxPoolSize(Integer.valueOf(poolSize));
        profile.setKeepAliveTime(Long.valueOf(0L));
        profile.setAllowCoreThreadTimeOut(Boolean.valueOf(false));
        return this.newThreadPool(source, name, profile);
    }

    public ScheduledExecutorService newSingleThreadScheduledExecutor(Object source, String name) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(Integer.valueOf(1));
        profile.setMaxPoolSize(Integer.valueOf(1));
        profile.setKeepAliveTime(Long.valueOf(0L));
        profile.setAllowCoreThreadTimeOut(Boolean.valueOf(false));
        return this.newScheduledThreadPool(source, name, profile);
    }

    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, ThreadPoolProfile profile) {
        String sanitizedName = URISupport.sanitizeUri((String)name);
        profile.addDefaults(this.getDefaultThreadPoolProfile());
        ScheduledExecutorService answer = this.threadPoolFactory.newScheduledThreadPool(profile, this.createThreadFactory(sanitizedName, true));
        this.onThreadPoolCreated(answer, source, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created new ScheduledThreadPool for source: {} with name: {} -> {}", new Object[]{source, sanitizedName, answer});
        }
        return answer;
    }

    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, String profileId) {
        ThreadPoolProfile profile = this.getThreadPoolProfile(profileId);
        if (profile != null) {
            return this.newScheduledThreadPool(source, name, profile);
        }
        return null;
    }

    public ScheduledExecutorService newScheduledThreadPool(Object source, String name, int poolSize) {
        ThreadPoolProfile profile = new ThreadPoolProfile(name);
        profile.setPoolSize(Integer.valueOf(poolSize));
        return this.newScheduledThreadPool(source, name, profile);
    }

    public void shutdown(ExecutorService executorService) {
        this.doShutdown(executorService, 0L, false);
    }

    public void shutdownGraceful(ExecutorService executorService) {
        this.doShutdown(executorService, this.getShutdownAwaitTermination(), false);
    }

    public void shutdownGraceful(ExecutorService executorService, long shutdownAwaitTermination) {
        this.doShutdown(executorService, shutdownAwaitTermination, false);
    }

    private boolean doShutdown(ExecutorService executorService, long shutdownAwaitTermination, boolean failSafe) {
        if (executorService == null) {
            return false;
        }
        boolean warned = false;
        if (!executorService.isShutdown()) {
            StopWatch watch = new StopWatch();
            LOG.trace("Shutdown of ExecutorService: {} with await termination: {} millis", (Object)executorService, (Object)shutdownAwaitTermination);
            executorService.shutdown();
            if (shutdownAwaitTermination > 0L) {
                try {
                    if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                        warned = true;
                        LOG.warn("Forcing shutdown of ExecutorService: {} due first await termination elapsed.", (Object)executorService);
                        executorService.shutdownNow();
                        if (!this.awaitTermination(executorService, shutdownAwaitTermination)) {
                            LOG.warn("Cannot completely force shutdown of ExecutorService: {} due second await termination elapsed.", (Object)executorService);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    warned = true;
                    LOG.warn("Forcing shutdown of ExecutorService: {} due interrupted.", (Object)executorService);
                    executorService.shutdownNow();
                }
            }
            if (warned) {
                LOG.info("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {} took: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated(), TimeUtils.printDuration((long)watch.taken(), (boolean)true)});
            }
        }
        this.doRemove(executorService, failSafe);
        return warned;
    }

    private void doRemove(ExecutorService executorService, boolean failSafe) {
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor;
            threadPool = threadPoolExecutor = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            SizedScheduledExecutorService sizedScheduledExecutorService = (SizedScheduledExecutorService)executorService;
            threadPool = sizedScheduledExecutorService.getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolRemove(this.camelContext, threadPool);
            }
        }
        if (!failSafe) {
            this.executorServices.remove(executorService);
        }
    }

    public List<Runnable> shutdownNow(ExecutorService executorService) {
        return this.doShutdownNow(executorService);
    }

    private List<Runnable> doShutdownNow(ExecutorService executorService) {
        ObjectHelper.notNull((Object)executorService, (String)"executorService");
        List<Runnable> answer = null;
        if (!executorService.isShutdown()) {
            LOG.debug("Forcing shutdown of ExecutorService: {}", (Object)executorService);
            answer = executorService.shutdownNow();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Shutdown of ExecutorService: {} is shutdown: {} and terminated: {}.", new Object[]{executorService, executorService.isShutdown(), executorService.isTerminated()});
            }
        }
        this.doRemove(executorService, false);
        return answer;
    }

    public boolean awaitTermination(ExecutorService executorService, long shutdownAwaitTermination) throws InterruptedException {
        StopWatch watch = new StopWatch();
        long interval = Math.min(2000L, shutdownAwaitTermination);
        boolean done = false;
        while (!done && interval > 0L) {
            if (executorService.awaitTermination(interval, TimeUnit.MILLISECONDS)) {
                done = true;
                continue;
            }
            LOG.info("Waited {} for ExecutorService: {} to terminate...", (Object)TimeUtils.printDuration((long)watch.taken(), (boolean)true), (Object)executorService);
            interval = Math.min(2000L, shutdownAwaitTermination - watch.taken());
        }
        return done;
    }

    protected void onNewExecutorService(ExecutorService executorService) {
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.threadNamePattern == null) {
            this.threadNamePattern = "Camel (" + this.camelContext.getName() + ") thread ##counter# - #name#";
        }
        if (this.threadPoolFactory == null) {
            this.threadPoolFactory = ResolverHelper.resolveService((CamelContext)this.camelContext, (FactoryFinder)this.camelContext.getCamelContextExtension().getBootstrapFactoryFinder(), (String)"thread-pool-factory", ThreadPoolFactory.class).orElseGet(DefaultThreadPoolFactory::new);
        }
        CamelContextAware.trySetCamelContext((Object)this.threadPoolFactory, (CamelContext)this.camelContext);
        ServiceHelper.initService((Object)this.threadPoolFactory);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.threadPoolFactory);
    }

    protected void doShutdown() throws Exception {
        LinkedHashSet<ExecutorService> forced = new LinkedHashSet<ExecutorService>();
        if (!this.executorServices.isEmpty()) {
            LOG.debug("Giving time for {} ExecutorService's to shutdown properly (acting as fail-safe)", (Object)this.executorServices.size());
            for (ExecutorService executorService : this.executorServices) {
                try {
                    boolean warned = this.doShutdown(executorService, this.getShutdownAwaitTermination(), true);
                    if (!warned) continue;
                    forced.add(executorService);
                }
                catch (Exception e) {
                    LOG.warn("Error occurred during shutdown of ExecutorService: {}. This exception will be ignored.", (Object)executorService, (Object)e);
                }
            }
        }
        if (!forced.isEmpty()) {
            LOG.warn("Forced shutdown of {} ExecutorService's which has not been shutdown properly (acting as fail-safe)", (Object)forced.size());
            for (ExecutorService executorService : forced) {
                LOG.warn("  forced -> {}", (Object)executorService);
            }
        }
        forced.clear();
        this.executorServices.clear();
        Iterator<ThreadPoolProfile> it = this.threadPoolProfiles.values().iterator();
        while (it.hasNext()) {
            ThreadPoolProfile profile = it.next();
            if (profile.isDefaultProfile().booleanValue()) continue;
            it.remove();
        }
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.threadPoolFactory});
    }

    private void onThreadPoolCreated(ExecutorService executorService, Object source, String threadPoolProfileId) {
        Object id;
        NamedNode namedNode;
        this.executorServices.add(executorService);
        String sourceId = null;
        String routeId = null;
        if (source instanceof NamedNode) {
            namedNode = (NamedNode)source;
            id = namedNode.getId();
            sourceId = namedNode.getShortName();
        } else if (source instanceof String) {
            String str = (String)source;
            id = str;
        } else {
            id = source != null ? (source instanceof StaticService ? source.getClass().getSimpleName() : source.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode((Object)source) + ")") : executorService.getClass().getSimpleName() + "(" + ObjectHelper.getIdentityHashCode((Object)executorService) + ")";
        }
        StringHelper.notEmpty((String)id, (String)("id for thread pool " + String.valueOf(executorService)));
        if (source instanceof NamedNode) {
            namedNode = (NamedNode)source;
            routeId = CamelContextHelper.getRouteId((NamedNode)namedNode);
        }
        ThreadPoolExecutor threadPool = null;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor;
            threadPool = threadPoolExecutor = (ThreadPoolExecutor)executorService;
        } else if (executorService instanceof SizedScheduledExecutorService) {
            SizedScheduledExecutorService scheduledExecutorService = (SizedScheduledExecutorService)executorService;
            threadPool = scheduledExecutorService.getScheduledThreadPoolExecutor();
        }
        if (threadPool != null) {
            for (LifecycleStrategy lifecycle : this.camelContext.getLifecycleStrategies()) {
                lifecycle.onThreadPoolAdd(this.camelContext, threadPool, (String)id, sourceId, routeId, threadPoolProfileId);
            }
        }
        this.onNewExecutorService(executorService);
    }

    protected ThreadFactory createThreadFactory(String name, boolean isDaemon) {
        return new CamelThreadFactory(this.threadNamePattern, name, isDaemon);
    }
}

