/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.SocketAddress;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.handlers.ServerResponseFutureListener;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private final NettyConsumer consumer;
    private final CamelLogger noReplyLogger;

    public ServerChannelHandler(NettyConsumer consumer) {
        this.consumer = consumer;
        this.noReplyLogger = new CamelLogger(LOG, consumer.getConfiguration().getNoReplyLogLevel());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel open: {}", (Object)ctx.channel());
        }
        this.consumer.getNettyServerBootstrapFactory().addChannel(ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel closed: {}", (Object)ctx.channel());
        }
        this.consumer.getNettyServerBootstrapFactory().removeChannel(ctx.channel());
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.consumer.isRunAllowed()) {
            this.consumer.getExceptionHandler().handleException("Closing channel as an exception was thrown from Netty", cause);
            NettyHelper.close(ctx.channel());
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Object in = msg;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", (Object)ctx.channel(), in);
        }
        Exchange exchange = this.consumer.getEndpoint().createExchange(ctx, msg);
        if (this.consumer.getConfiguration().isSync()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        if (this.consumer.getConfiguration().getCharsetName() != null) {
            exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)this.consumer.getConfiguration().getCharsetName()));
        }
        if (this.consumer.getConfiguration().isReuseChannel()) {
            exchange.setProperty("CamelNettyChannel", (Object)ctx.channel());
        }
        this.consumer.createUoW(exchange);
        this.beforeProcess(exchange, ctx, msg);
        if (this.consumer.getEndpoint().isSynchronous()) {
            this.processSynchronously(exchange, ctx, msg);
        } else {
            this.processAsynchronously(exchange, ctx, msg);
        }
    }

    protected void beforeProcess(Exchange exchange, ChannelHandlerContext ctx, Object message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSynchronously(Exchange exchange, ChannelHandlerContext ctx, Object message) {
        try {
            this.consumer.getProcessor().process(exchange);
            if (this.consumer.getConfiguration().isSync()) {
                this.sendResponse(message, ctx, exchange);
            }
        }
        catch (Throwable e) {
            this.consumer.getExceptionHandler().handleException(e);
        }
        finally {
            this.consumer.doneUoW(exchange);
        }
    }

    private void processAsynchronously(final Exchange exchange, final ChannelHandlerContext ctx, final Object message) {
        this.consumer.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                try {
                    if (ServerChannelHandler.this.consumer.getConfiguration().isSync()) {
                        ServerChannelHandler.this.sendResponse(message, ctx, exchange);
                    }
                }
                catch (Throwable e) {
                    ServerChannelHandler.this.consumer.getExceptionHandler().handleException(e);
                }
                finally {
                    ServerChannelHandler.this.consumer.doneUoW(exchange);
                }
            }
        });
    }

    private void sendResponse(Object message, ChannelHandlerContext ctx, Exchange exchange) throws Exception {
        Object body = this.getResponseBody(exchange);
        if (body == null) {
            this.noReplyLogger.log("No payload to send as reply for exchange: " + exchange);
            if (this.consumer.getConfiguration().isDisconnectOnNoReply()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel as no payload to send as reply at address: {}", (Object)ctx.channel().remoteAddress());
                }
                NettyHelper.close(ctx.channel());
            }
        } else {
            if (this.consumer.getConfiguration().isTextline()) {
                body = NettyHelper.getTextlineBody(body, exchange, this.consumer.getConfiguration().getDelimiter(), this.consumer.getConfiguration().isAutoAppendDelimiter());
            }
            ChannelFutureListener listener = this.createResponseFutureListener(this.consumer, exchange, ctx.channel().remoteAddress());
            if (this.consumer.getConfiguration().isTcp()) {
                NettyHelper.writeBodyAsync(LOG, ctx.channel(), null, body, exchange, listener);
            } else {
                NettyHelper.writeBodyAsync(LOG, ctx.channel(), (SocketAddress)exchange.getProperty("CamelNettyRemoteAddress", SocketAddress.class), body, exchange, listener);
            }
        }
    }

    protected Object getResponseBody(Exchange exchange) throws Exception {
        boolean exception;
        boolean bl = exception = exchange.getException() != null && !this.consumer.getEndpoint().getConfiguration().isTransferExchange();
        if (exception) {
            return exchange.getException();
        }
        if (exchange.hasOut()) {
            return NettyPayloadHelper.getOut(this.consumer.getEndpoint(), exchange);
        }
        return NettyPayloadHelper.getIn(this.consumer.getEndpoint(), exchange);
    }

    protected ChannelFutureListener createResponseFutureListener(NettyConsumer consumer, Exchange exchange, SocketAddress remoteAddress) {
        return new ServerResponseFutureListener(consumer, exchange, remoteAddress);
    }
}

