/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.ssh.transformers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.commons.io.IOUtils;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshTransforms<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String FIELD_KEY_CONFIG = "key";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("key", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Transforms String-based content from Kafka into a map");
    private static final Logger LOG = LoggerFactory.getLogger(SshTransforms.class);

    public R apply(R r) {
        Object value = r.value();
        if (value instanceof ByteArrayInputStream) {
            LOG.debug("Converting record from Ssh Body Result to text");
            ByteArrayInputStream message = (ByteArrayInputStream)value;
            String m = null;
            try {
                m = IOUtils.toString((InputStream)message, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                LOG.error("Input/output error while transforming the SSH value of type {}: {}", new Object[]{value.getClass(), e.getMessage(), e});
            }
            return (R)r.newRecord(r.topic(), r.kafkaPartition(), null, r.key(), (Schema)SchemaHelper.buildSchemaBuilderForType((Object)m), (Object)m, r.timestamp());
        }
        LOG.debug("Unexpected message type: {}", value == null ? "null instance" : value.getClass());
        return r;
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
    }
}

