/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class DefaultKafkaClientFactory
implements KafkaClientFactory {
    @Override
    public Producer getProducer(Properties kafkaProps) {
        return new KafkaProducer(kafkaProps);
    }

    @Override
    public Consumer getConsumer(Properties kafkaProps) {
        return new KafkaConsumer(kafkaProps);
    }

    @Override
    public String getBrokers(KafkaConfiguration configuration) {
        String brokers = configuration.getBrokers();
        if (ObjectHelper.isEmpty((String)brokers)) {
            throw new IllegalArgumentException("URL to the Kafka brokers must be configured with the brokers option.");
        }
        return brokers;
    }
}

