/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.model.rest.RestPropertyDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.StringHelper;

@Metadata(label="rest")
@XmlRootElement(name="param")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ParamDefinition {
    @XmlTransient
    private VerbDefinition verb;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute(required=true)
    @Metadata(defaultValue="path")
    private RestParamType type;
    @XmlAttribute
    private String description;
    @XmlAttribute
    private String defaultValue;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean required;
    @XmlAttribute
    @Metadata(defaultValue="csv")
    private CollectionFormat collectionFormat;
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String arrayType;
    @XmlAttribute
    @Metadata(defaultValue="string")
    private String dataType;
    @XmlAttribute
    private String dataFormat;
    @XmlElementWrapper(name="allowableValues")
    @XmlElement(name="value")
    private List<String> allowableValues;
    @XmlElement(name="examples")
    private List<RestPropertyDefinition> examples;

    public ParamDefinition() {
    }

    public ParamDefinition(VerbDefinition verb) {
        this.verb = verb;
    }

    public RestParamType getType() {
        return this.type != null ? this.type : RestParamType.path;
    }

    public void setType(RestParamType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : "";
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Boolean getRequired() {
        return this.required != null ? this.required : true;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public CollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public void setCollectionFormat(CollectionFormat collectionFormat) {
        this.collectionFormat = collectionFormat;
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public String getDataType() {
        return this.dataType != null ? this.dataType : "string";
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public List<String> getAllowableValues() {
        if (this.allowableValues != null) {
            return this.allowableValues;
        }
        return new ArrayList<String>();
    }

    public void setAllowableValues(List<String> allowableValues) {
        this.allowableValues = allowableValues;
    }

    public List<RestPropertyDefinition> getExamples() {
        return this.examples;
    }

    public void setExamples(List<RestPropertyDefinition> examples) {
        this.examples = examples;
    }

    public ParamDefinition name(String name) {
        this.setName(name);
        return this;
    }

    public ParamDefinition description(String name) {
        this.setDescription(name);
        return this;
    }

    public ParamDefinition defaultValue(String name) {
        this.setDefaultValue(name);
        return this;
    }

    public ParamDefinition required(Boolean required) {
        this.setRequired(required);
        return this;
    }

    public ParamDefinition collectionFormat(CollectionFormat collectionFormat) {
        this.setCollectionFormat(collectionFormat);
        return this;
    }

    public ParamDefinition arrayType(String arrayType) {
        this.setArrayType(arrayType);
        return this;
    }

    public ParamDefinition dataType(String type) {
        this.setDataType(type);
        return this;
    }

    public ParamDefinition dataFormat(String type) {
        this.setDataFormat(type);
        return this;
    }

    public ParamDefinition allowableValues(List<String> allowableValues) {
        this.setAllowableValues(allowableValues);
        return this;
    }

    public ParamDefinition allowableValues(String ... allowableValues) {
        this.setAllowableValues(Arrays.asList(allowableValues));
        return this;
    }

    public ParamDefinition allowableValues(String allowableValues) {
        this.setAllowableValues(Arrays.asList(allowableValues.split(",")));
        return this;
    }

    public ParamDefinition type(RestParamType type) {
        this.setType(type);
        return this;
    }

    public ParamDefinition example(String contentType, String example) {
        if (this.examples == null) {
            this.examples = new ArrayList<RestPropertyDefinition>();
        }
        this.examples.add(new RestPropertyDefinition(contentType, example));
        return this;
    }

    public ParamDefinition example(String example) {
        if (this.examples == null) {
            this.examples = new ArrayList<RestPropertyDefinition>();
        }
        this.examples.add(new RestPropertyDefinition("", example));
        return this;
    }

    public RestDefinition endParam() {
        StringHelper.notEmpty((String)this.name, (String)"name");
        this.verb.getParams().add(this);
        return this.verb.getRest();
    }
}

