/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.resume;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdapterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterHelper.class);

    private AdapterHelper() {
    }

    public static ResumeAdapter eval(CamelContext context, ResumeAware resumeAware) {
        assert (context != null);
        assert (resumeAware != null);
        LOG.debug("Using the factory finder to search for the resume adapter");
        FactoryFinder factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/");
        LOG.debug("Creating a new resume adapter");
        Optional adapterOptional = factoryFinder.newInstance(resumeAware.adapterFactoryService(), ResumeAdapter.class);
        if (!adapterOptional.isPresent()) {
            throw new RuntimeException("Cannot find a resume adapter class in the consumer classpath or in the registry");
        }
        ResumeAdapter resumeAdapter = (ResumeAdapter)adapterOptional.get();
        LOG.debug("Using the acquired resume adapter: {}", (Object)resumeAdapter.getClass().getName());
        Object cacheObj = context.getRegistry().lookupByName("resumeCache");
        if (resumeAdapter instanceof Cacheable && cacheObj instanceof ResumeCache) {
            ((Cacheable)resumeAdapter).setCache((ResumeCache)cacheObj);
        } else {
            LOG.debug("The resume adapter {} is not cacheable", (Object)resumeAdapter.getClass().getName());
        }
        return resumeAdapter;
    }
}

