/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail.monitor;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.ws.transport.mail.monitor.PollingMonitoringStrategy;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class Pop3PollingMonitoringStrategy
extends PollingMonitoringStrategy {
    public Pop3PollingMonitoringStrategy() {
        super.setDeleteMessages(true);
    }

    @Override
    public void setDeleteMessages(boolean deleteMessages) {
    }

    @Override
    protected void afterSleep(Folder folder) throws MessagingException {
        if (!folder.isOpen()) {
            folder.open(2);
        }
    }

    @Override
    protected Message[] searchForNewMessages(Folder folder) throws MessagingException {
        return folder.getMessages();
    }

    @Override
    protected void deleteMessages(Folder folder, Message[] messages) throws MessagingException {
        super.deleteMessages(folder, messages);
        for (Message message : messages) {
            new MimeMessage((MimeMessage)message);
        }
        MailTransportUtils.closeFolder(folder, true);
    }
}

