/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractMethodEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;
import org.springframework.xml.transform.TransformerFactoryUtils;

public class SimpleMethodEndpointMapping
extends AbstractMethodEndpointMapping<String>
implements InitializingBean {
    public static final String DEFAULT_METHOD_PREFIX = "handle";
    public static final String DEFAULT_METHOD_SUFFIX = "";
    private Object[] endpoints;
    private String methodPrefix = "handle";
    private String methodSuffix = "";
    private TransformerFactory transformerFactory;

    public Object[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Object[] endpoints) {
        this.endpoints = endpoints;
    }

    public String getMethodPrefix() {
        return this.methodPrefix;
    }

    public void setMethodPrefix(String methodPrefix) {
        this.methodPrefix = methodPrefix;
    }

    public String getMethodSuffix() {
        return this.methodSuffix;
    }

    public void setMethodSuffix(String methodSuffix) {
        this.methodSuffix = methodSuffix;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Object[])this.getEndpoints(), (String)"'endpoints' is required");
        this.transformerFactory = TransformerFactoryUtils.newInstance();
        for (int i = 0; i < this.getEndpoints().length; ++i) {
            this.registerMethods(this.getEndpoints()[i]);
        }
    }

    @Override
    protected String getLookupKeyForMethod(Method method) {
        String methodName = method.getName();
        String prefix = this.getMethodPrefix();
        String suffix = this.getMethodSuffix();
        if (methodName.startsWith(prefix) && methodName.endsWith(suffix)) {
            return methodName.substring(prefix.length(), methodName.length() - suffix.length());
        }
        return null;
    }

    @Override
    protected String getLookupKeyForMessage(MessageContext messageContext) throws TransformerException {
        WebServiceMessage request = messageContext.getRequest();
        QName rootQName = PayloadRootUtils.getPayloadRootQName(request.getPayloadSource(), this.transformerFactory);
        return rootQName.getLocalPart();
    }
}

