/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpTransportException;
import org.springframework.ws.transport.http.HttpUrlConnection;

public class HttpUrlConnectionMessageSender
extends AbstractHttpWebServiceMessageSender {
    private Duration connectionTimeout = Duration.ofSeconds(60L);
    private Duration readTimeout = Duration.ofSeconds(60L);

    public void setConnectionTimeout(Duration connectTimeout) {
        this.connectionTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        URL url = uri.toURL();
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new HttpTransportException("URI [" + uri + "] is not an HTTP URL");
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
        this.prepareConnection(httpURLConnection);
        return new HttpUrlConnection(httpURLConnection);
    }

    protected void prepareConnection(HttpURLConnection connection) throws IOException {
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (this.isAcceptGzipEncoding()) {
            connection.setRequestProperty("Accept-Encoding", "gzip");
        }
        connection.setConnectTimeout(Math.toIntExact(this.connectionTimeout.toMillis()));
        connection.setReadTimeout(Math.toIntExact(this.readTimeout.toMillis()));
    }
}

