/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.client.core.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.destination.DestinationProvider;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public abstract class WebServiceGatewaySupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebServiceTemplate webServiceTemplate;

    protected WebServiceGatewaySupport() {
        this.webServiceTemplate = new WebServiceTemplate();
    }

    protected WebServiceGatewaySupport(WebServiceMessageFactory messageFactory) {
        this.webServiceTemplate = new WebServiceTemplate(messageFactory);
    }

    public final WebServiceMessageFactory getMessageFactory() {
        return this.webServiceTemplate.getMessageFactory();
    }

    public final void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.webServiceTemplate.setMessageFactory(messageFactory);
    }

    public final String getDefaultUri() {
        return this.webServiceTemplate.getDefaultUri();
    }

    public final void setDefaultUri(String uri) {
        this.webServiceTemplate.setDefaultUri(uri);
    }

    public final DestinationProvider getDestinationProvider() {
        return this.webServiceTemplate.getDestinationProvider();
    }

    public final void setDestinationProvider(DestinationProvider destinationProvider) {
        this.webServiceTemplate.setDestinationProvider(destinationProvider);
    }

    public final void setMessageSender(WebServiceMessageSender messageSender) {
        this.webServiceTemplate.setMessageSender(messageSender);
    }

    public final WebServiceMessageSender[] getMessageSenders() {
        return this.webServiceTemplate.getMessageSenders();
    }

    public final void setMessageSenders(WebServiceMessageSender[] messageSenders) {
        this.webServiceTemplate.setMessageSenders(messageSenders);
    }

    public final WebServiceTemplate getWebServiceTemplate() {
        return this.webServiceTemplate;
    }

    public final void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        Assert.notNull((Object)webServiceTemplate, (String)"'webServiceTemplate' must not be null");
        this.webServiceTemplate = webServiceTemplate;
    }

    public final Marshaller getMarshaller() {
        return this.webServiceTemplate.getMarshaller();
    }

    public final void setMarshaller(Marshaller marshaller) {
        this.webServiceTemplate.setMarshaller(marshaller);
    }

    public final Unmarshaller getUnmarshaller() {
        return this.webServiceTemplate.getUnmarshaller();
    }

    public final void setUnmarshaller(Unmarshaller unmarshaller) {
        this.webServiceTemplate.setUnmarshaller(unmarshaller);
    }

    public final ClientInterceptor[] getInterceptors() {
        return this.webServiceTemplate.getInterceptors();
    }

    public final void setInterceptors(ClientInterceptor[] interceptors) {
        this.webServiceTemplate.setInterceptors(interceptors);
    }

    public final void afterPropertiesSet() throws Exception {
        this.webServiceTemplate.afterPropertiesSet();
        this.initGateway();
    }

    protected void initGateway() throws Exception {
    }
}

