/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XsltSaxonHelper {
    private static final Logger LOG = LoggerFactory.getLogger(XsltSaxonHelper.class);

    private XsltSaxonHelper() {
    }

    public static void registerSaxonConfiguration(TransformerFactoryImpl factory, Configuration saxonConfiguration) throws Exception {
        if (saxonConfiguration != null) {
            factory.setConfiguration(saxonConfiguration);
        }
    }

    public static void registerSaxonConfigurationProperties(TransformerFactoryImpl factory, Map<String, Object> saxonConfigurationProperties) throws Exception {
        if (saxonConfigurationProperties != null && !saxonConfigurationProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : saxonConfigurationProperties.entrySet()) {
                factory.getConfiguration().setConfigurationProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void registerSaxonExtensionFunctions(TransformerFactoryImpl factory, List<Object> saxonExtensionFunctions) throws Exception {
        if (saxonExtensionFunctions != null && !saxonExtensionFunctions.isEmpty()) {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            for (Object extensionFunction : saxonExtensionFunctions) {
                if (!(extensionFunction instanceof ExtensionFunctionDefinition)) continue;
                LOG.debug("Saxon.registerExtensionFunction {}", extensionFunction);
                factory.getConfiguration().registerExtensionFunction((ExtensionFunctionDefinition)extensionFunction);
            }
        }
    }
}

