/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.transforms.util.SchemaUtil;

public final class SchemaHelper {
    private SchemaHelper() {
    }

    public static SchemaBuilder buildSchemaBuilderForType(Object value) {
        Objects.requireNonNull(value);
        Schema knownSchema = Values.inferSchema((Object)value);
        if (knownSchema == null) {
            if (value instanceof Date) {
                return org.apache.kafka.connect.data.Date.builder();
            }
            if (value instanceof BigDecimal) {
                return Decimal.builder((int)((BigDecimal)value).scale());
            }
            if (value instanceof Map) {
                return new SchemaBuilder(Schema.Type.MAP);
            }
            if (value instanceof List) {
                return new SchemaBuilder(Schema.Type.ARRAY);
            }
            return SchemaBuilder.bytes().optional();
        }
        return SchemaUtil.copySchemaBasics((Schema)knownSchema);
    }
}

