/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.OutputExpressionNode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="idempotentConsumer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IdempotentConsumerDefinition
extends OutputExpressionNode {
    @XmlAttribute(required=true)
    private String messageIdRepositoryRef;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String eager;
    @XmlAttribute
    private String completionEager;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String skipDuplicate;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String removeOnFailure;
    @XmlTransient
    private IdempotentRepository idempotentRepository;

    public IdempotentConsumerDefinition() {
    }

    public IdempotentConsumerDefinition(Expression messageIdExpression, IdempotentRepository idempotentRepository) {
        super(messageIdExpression);
        this.idempotentRepository = idempotentRepository;
    }

    public String toString() {
        return "IdempotentConsumer[" + this.getExpression() + " -> " + this.getOutputs() + "]";
    }

    public String getShortName() {
        return "idempotentConsumer";
    }

    @Override
    public String getLabel() {
        return "idempotentConsumer[" + this.getExpression() + "]";
    }

    public IdempotentConsumerDefinition messageIdRepositoryRef(String messageIdRepositoryRef) {
        this.setMessageIdRepositoryRef(messageIdRepositoryRef);
        return this;
    }

    public IdempotentConsumerDefinition messageIdRepository(IdempotentRepository idempotentRepository) {
        this.setMessageIdRepository(idempotentRepository);
        return this;
    }

    public IdempotentConsumerDefinition messageIdRepository(Supplier<IdempotentRepository> idempotentRepository) {
        this.setMessageIdRepository(idempotentRepository.get());
        return this;
    }

    public IdempotentConsumerDefinition eager(boolean eager) {
        this.setEager(Boolean.toString(eager));
        return this;
    }

    public IdempotentConsumerDefinition completionEager(boolean completionEager) {
        this.setCompletionEager(Boolean.toString(completionEager));
        return this;
    }

    public IdempotentConsumerDefinition removeOnFailure(boolean removeOnFailure) {
        this.setRemoveOnFailure(Boolean.toString(removeOnFailure));
        return this;
    }

    public IdempotentConsumerDefinition skipDuplicate(boolean skipDuplicate) {
        this.setSkipDuplicate(Boolean.toString(skipDuplicate));
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getMessageIdRepositoryRef() {
        return this.messageIdRepositoryRef;
    }

    public void setMessageIdRepositoryRef(String messageIdRepositoryRef) {
        this.messageIdRepositoryRef = messageIdRepositoryRef;
    }

    public IdempotentRepository getMessageIdRepository() {
        return this.idempotentRepository;
    }

    public void setMessageIdRepository(IdempotentRepository idempotentRepository) {
        this.idempotentRepository = idempotentRepository;
    }

    public String getEager() {
        return this.eager;
    }

    public void setEager(String eager) {
        this.eager = eager;
    }

    public String getSkipDuplicate() {
        return this.skipDuplicate;
    }

    public void setSkipDuplicate(String skipDuplicate) {
        this.skipDuplicate = skipDuplicate;
    }

    public String getRemoveOnFailure() {
        return this.removeOnFailure;
    }

    public void setRemoveOnFailure(String removeOnFailure) {
        this.removeOnFailure = removeOnFailure;
    }

    public String getCompletionEager() {
        return this.completionEager;
    }

    public void setCompletionEager(String completionEager) {
        this.completionEager = completionEager;
    }
}

