/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.attachment.DefaultAttachmentMessage;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.SpringWebserviceHelper;
import org.apache.camel.component.spring.ws.SpringWebserviceMessage;
import org.apache.camel.support.DefaultConsumer;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;

public class SpringWebserviceConsumer
extends DefaultConsumer
implements MessageEndpoint {
    private SpringWebserviceEndpoint endpoint;
    private SpringWebserviceConfiguration configuration;

    public SpringWebserviceConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (SpringWebserviceEndpoint)endpoint;
        this.configuration = this.endpoint.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext messageContext) throws Exception {
        Exchange exchange = this.createExchange(false);
        try {
            Message responseMessage;
            exchange.setPattern(ExchangePattern.InOptionalOut);
            this.populateExchangeFromMessageContext(messageContext, exchange);
            if (this.getEndpoint().getCamelContext().isUseBreadcrumb().booleanValue()) {
                this.populateExchangeWithBreadcrumbFromMessageContext(messageContext, exchange);
            }
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            if (exchange.getPattern().isOutCapable() && (responseMessage = (Message)exchange.getMessage(Message.class)) != null) {
                Source responseBody = (Source)responseMessage.getBody(Source.class);
                WebServiceMessage response = messageContext.getResponse();
                this.configuration.getMessageFilter().filterConsumer(exchange, response);
                SpringWebserviceHelper.toResult(responseBody, response.getPayloadResult());
            }
        }
        finally {
            this.releaseExchange(exchange, false);
        }
    }

    private void populateExchangeWithBreadcrumbFromMessageContext(MessageContext messageContext, Exchange exchange) {
        if (messageContext.getRequest() instanceof SaajSoapMessage) {
            SaajSoapMessage saajSoap = (SaajSoapMessage)messageContext.getRequest();
            this.populateExchangeWithBreadcrumbFromSaajMessage(exchange, saajSoap);
        } else {
            this.populateExchangeWithBreadcrumbFromMessageContext(exchange, messageContext);
        }
    }

    private void populateExchangeWithBreadcrumbFromSaajMessage(Exchange exchange, SaajSoapMessage saajSoap) {
        String[] breadcrumbIdHeaderValues;
        MimeHeaders mimeHeaders;
        SOAPMessage soapMessageRequest;
        if (saajSoap != null && (soapMessageRequest = saajSoap.getSaajMessage()) != null && (mimeHeaders = soapMessageRequest.getMimeHeaders()) != null && (breadcrumbIdHeaderValues = mimeHeaders.getHeader("breadcrumbId")) != null && breadcrumbIdHeaderValues.length >= 1) {
            exchange.getIn().setHeader("breadcrumbId", (Object)breadcrumbIdHeaderValues[0]);
        }
    }

    private void populateExchangeWithBreadcrumbFromMessageContext(Exchange exchange, MessageContext messageContext) {
        HttpServletRequest obj;
        String breadcrumbId;
        if (messageContext != null && (breadcrumbId = (obj = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest")).getHeader("breadcrumbId")) != null) {
            exchange.getIn().setHeader("breadcrumbId", (Object)breadcrumbId);
        }
    }

    private void populateExchangeFromMessageContext(MessageContext messageContext, Exchange exchange) {
        this.populateExchangeWithPropertiesFromMessageContext(messageContext, exchange);
        WebServiceMessage request = messageContext.getRequest();
        SpringWebserviceMessage swm = (SpringWebserviceMessage)((Object)((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).getInOrNull(SpringWebserviceMessage.class));
        if (swm == null) {
            swm = new SpringWebserviceMessage(exchange.getContext(), request);
            exchange.setIn((Message)swm);
        } else {
            swm.setWebServiceMessage(request);
        }
        this.extractSourceFromSoapHeader(exchange.getIn().getHeaders(), request);
        this.extractAttachmentsFromRequest(request, exchange);
    }

    private void populateExchangeWithPropertiesFromMessageContext(MessageContext messageContext, Exchange exchange) {
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                exchange.setProperty(propertyName, messageContext.getProperty(propertyName));
            }
        }
    }

    private void extractSourceFromSoapHeader(Map<String, Object> headers, WebServiceMessage request) {
        SoapMessage soapMessage;
        SoapHeader soapHeader;
        if (request instanceof SoapMessage && (soapHeader = (soapMessage = (SoapMessage)request).getSoapHeader()) != null) {
            headers.put("CamelSpringWebserviceSoapHeader", soapHeader.getSource());
            Iterator attIter = soapHeader.getAllAttributes();
            while (attIter.hasNext()) {
                QName name = (QName)attIter.next();
                headers.put(name.getLocalPart(), soapHeader.getAttributeValue(name));
            }
            Iterator elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                SoapHeaderElement element = (SoapHeaderElement)elementIter.next();
                QName name = element.getName();
                headers.put(name.getLocalPart(), element);
            }
        }
    }

    private void extractAttachmentsFromRequest(WebServiceMessage request, Exchange exchange) {
        DefaultAttachmentMessage dam = null;
        if (request instanceof MimeMessage) {
            Iterator attachmentsIterator = ((MimeMessage)request).getAttachments();
            while (attachmentsIterator.hasNext()) {
                Attachment attachment = (Attachment)attachmentsIterator.next();
                if (dam == null) {
                    dam = new DefaultAttachmentMessage(exchange.getIn());
                }
                dam.addAttachment(attachment.getContentId(), attachment.getDataHandler());
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().removeConsumer(this.configuration.getEndpointMappingKey());
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().addConsumer(this.configuration.getEndpointMappingKey(), this);
        }
        super.doStart();
    }
}

