/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.loadbalancer;

import java.util.ArrayList;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRandomLoadBalancer;
import org.apache.camel.processor.loadbalancer.WeightedRoundRobinLoadBalancer;
import org.apache.camel.reifier.loadbalancer.LoadBalancerReifier;
import org.apache.camel.spi.RouteContext;

public class WeightedLoadBalancerReifier
extends LoadBalancerReifier<WeightedLoadBalancerDefinition> {
    public WeightedLoadBalancerReifier(RouteContext routeContext, LoadBalancerDefinition definition) {
        super(routeContext, (WeightedLoadBalancerDefinition)definition);
    }

    @Override
    public LoadBalancer createLoadBalancer() {
        Object loadBalancer;
        ArrayList<Integer> distributionRatioList = new ArrayList<Integer>();
        try {
            String[] ratios;
            for (String ratio : ratios = ((WeightedLoadBalancerDefinition)this.definition).getDistributionRatio().split(((WeightedLoadBalancerDefinition)this.definition).getDistributionRatioDelimiter())) {
                distributionRatioList.add(this.parseInt(ratio.trim()));
            }
            boolean isRoundRobin = this.parseBoolean(((WeightedLoadBalancerDefinition)this.definition).getRoundRobin(), false);
            loadBalancer = isRoundRobin ? new WeightedRoundRobinLoadBalancer(distributionRatioList) : new WeightedRandomLoadBalancer(distributionRatioList);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return loadBalancer;
    }
}

