/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPagingItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected boolean initialized = false;
    protected int current = 0;
    protected int page = 0;
    protected int pageSize = 10;
    protected List<T> results;

    public AbstractPagingItemReader() {
        this.setName(ClassUtils.getShortName(AbstractPagingItemReader.class));
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
    }

    @Override
    protected T doRead() throws Exception {
        if (this.results == null || this.current >= this.pageSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Reading page " + this.page));
            }
            this.doReadPage();
            if (this.current >= this.pageSize) {
                this.current = 0;
            }
            ++this.page;
        }
        if (this.current < this.results.size()) {
            return this.results.get(this.current++);
        }
        return null;
    }

    protected abstract void doReadPage();

    @Override
    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        this.initialized = true;
    }

    @Override
    protected void doClose() throws Exception {
        this.initialized = false;
        this.current = 0;
        this.page = 0;
        this.results = null;
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        this.page = itemIndex / this.pageSize;
        this.current = itemIndex % this.pageSize;
        this.doJumpToPage(itemIndex);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Jumping to page " + this.page + " and index " + this.current));
        }
    }

    protected abstract void doJumpToPage(int var1);
}

