/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemCountingItemStreamItemReader<T>
implements ItemReader<T>,
ItemStream {
    private static final String READ_COUNT = "read.count";
    private static final String READ_COUNT_MAX = "read.count.max";
    private int currentItemCount = 0;
    private int maxItemCount = Integer.MAX_VALUE;
    private ExecutionContextUserSupport ecSupport = new ExecutionContextUserSupport();
    private boolean saveState = true;

    protected abstract T doRead() throws Exception;

    protected abstract void doOpen() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.read();
        }
    }

    @Override
    public final T read() throws Exception, UnexpectedInputException, ParseException {
        if (this.currentItemCount >= this.maxItemCount) {
            return null;
        }
        ++this.currentItemCount;
        return this.doRead();
    }

    protected int getCurrentItemCount() {
        return this.currentItemCount;
    }

    public void setCurrentItemCount(int count) {
        this.currentItemCount = count;
    }

    public void setMaxItemCount(int count) {
        this.maxItemCount = count;
    }

    @Override
    public void close() throws ItemStreamException {
        this.currentItemCount = 0;
        try {
            this.doClose();
        }
        catch (Exception e) {
            throw new ItemStreamException("Error while closing item reader", e);
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        try {
            this.doOpen();
        }
        catch (Exception e) {
            throw new ItemStreamException("Failed to initialize the reader", e);
        }
        if (executionContext.containsKey(this.ecSupport.getKey(READ_COUNT_MAX))) {
            this.maxItemCount = executionContext.getInt(this.ecSupport.getKey(READ_COUNT_MAX));
        }
        if (executionContext.containsKey(this.ecSupport.getKey(READ_COUNT))) {
            int itemCount = executionContext.getInt(this.ecSupport.getKey(READ_COUNT));
            if (itemCount < this.maxItemCount) {
                try {
                    this.jumpToItem(itemCount);
                }
                catch (Exception e) {
                    throw new ItemStreamException("Could not move to stored position on restart", e);
                }
            }
            this.currentItemCount = itemCount;
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putInt(this.ecSupport.getKey(READ_COUNT), this.currentItemCount);
            if (this.maxItemCount < Integer.MAX_VALUE) {
                executionContext.putInt(this.ecSupport.getKey(READ_COUNT_MAX), this.maxItemCount);
            }
        }
    }

    public void setName(String name) {
        this.ecSupport.setName(name);
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

