/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.orm.ibatis.SqlMapClientTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatisPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private SqlMapClient sqlMapClient;
    private String queryId;
    private SqlMapClientTemplate sqlMapClientTemplate;
    private Map<String, Object> parameterValues;

    public IbatisPagingItemReader() {
        this.setName(ClassUtils.getShortName(IbatisPagingItemReader.class));
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.sqlMapClient);
        this.sqlMapClientTemplate = new SqlMapClientTemplate(this.sqlMapClient);
        Assert.notNull((Object)this.queryId);
    }

    @Override
    protected void doReadPage() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.parameterValues != null) {
            parameters.putAll(this.parameterValues);
        }
        parameters.put("_page", this.page);
        parameters.put("_pagesize", this.pageSize);
        parameters.put("_skiprows", this.page * this.pageSize);
        this.results = this.sqlMapClientTemplate.queryForList(this.queryId, parameters);
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }
}

