/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class StreamCacheConverterLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        StreamCacheConverterLoader.addTypeConverter(registry, byte[].class, StreamCache.class, false, (type, exchange, value) -> StreamCacheConverter.convertToByteArray((StreamCache)value, exchange));
        StreamCacheConverterLoader.addTypeConverter(registry, ByteBuffer.class, StreamCache.class, false, (type, exchange, value) -> StreamCacheConverter.convertToByteBuffer((StreamCache)value, exchange));
        StreamCacheConverterLoader.addTypeConverter(registry, StreamCache.class, ByteArrayInputStream.class, false, (type, exchange, value) -> StreamCacheConverter.convertToStreamCache((ByteArrayInputStream)value, exchange));
        StreamCacheConverterLoader.addTypeConverter(registry, StreamCache.class, InputStream.class, false, (type, exchange, value) -> StreamCacheConverter.convertToStreamCache((InputStream)value, exchange));
        StreamCacheConverterLoader.addTypeConverter(registry, StreamCache.class, Reader.class, false, (type, exchange, value) -> StreamCacheConverter.convertToStreamCache((Reader)value, exchange));
        StreamCacheConverterLoader.addTypeConverter(registry, StreamCache.class, CachedOutputStream.class, false, (type, exchange, value) -> StreamCacheConverter.convertToStreamCache((CachedOutputStream)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

