/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ResolvableType;
import org.springframework.integration.mapping.support.JsonHeaders;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public class JsonToObjectTransformer
extends AbstractTransformer
implements BeanClassLoaderAware {
    private final ResolvableType targetType;
    private final JsonObjectMapper<?, ?> jsonObjectMapper;
    private ClassLoader classLoader;

    public JsonToObjectTransformer() {
        this((Class)null);
    }

    public JsonToObjectTransformer(@Nullable Class<?> targetClass) {
        this(ResolvableType.forClass(targetClass));
    }

    public JsonToObjectTransformer(ResolvableType targetType) {
        this(targetType, null);
    }

    public JsonToObjectTransformer(@Nullable JsonObjectMapper<?, ?> jsonObjectMapper) {
        this((Class)null, jsonObjectMapper);
    }

    public JsonToObjectTransformer(@Nullable Class<?> targetClass, @Nullable JsonObjectMapper<?, ?> jsonObjectMapper) {
        this(ResolvableType.forClass(targetClass), jsonObjectMapper);
    }

    public JsonToObjectTransformer(ResolvableType targetType, @Nullable JsonObjectMapper<?, ?> jsonObjectMapper) {
        Assert.notNull((Object)targetType, (String)"'targetType' must not be null");
        this.targetType = targetType;
        this.jsonObjectMapper = jsonObjectMapper != null ? jsonObjectMapper : JsonObjectMapperProvider.newInstance();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (this.jsonObjectMapper instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)this.jsonObjectMapper).setBeanClassLoader(classLoader);
        }
    }

    @Override
    public String getComponentType() {
        return "json-to-object-transformer";
    }

    @Override
    protected Object doTransform(Message<?> message) {
        Object result;
        MessageHeaders headers = message.getHeaders();
        boolean removeHeaders = false;
        ResolvableType valueType = this.obtainResolvableTypeFromHeadersIfAny(headers);
        if (valueType != null) {
            removeHeaders = true;
        } else {
            valueType = this.targetType;
        }
        try {
            result = this.jsonObjectMapper.fromJson(message.getPayload(), valueType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (removeHeaders) {
            return this.getMessageBuilderFactory().withPayload(result).copyHeaders((Map<String, ?>)headers).removeHeaders(JsonHeaders.HEADERS.toArray(new String[0])).build();
        }
        return result;
    }

    @Nullable
    private ResolvableType obtainResolvableTypeFromHeadersIfAny(MessageHeaders headers) {
        Object valueType = headers.get((Object)"json_resolvableType");
        Object typeIdHeader = headers.get((Object)"json__TypeId__");
        if (!(valueType instanceof ResolvableType) && typeIdHeader != null) {
            valueType = JsonHeaders.buildResolvableType(this.classLoader, typeIdHeader, headers.get((Object)"json__ContentTypeId__"), headers.get((Object)"json__KeyTypeId__"));
        }
        return valueType instanceof ResolvableType ? (ResolvableType)valueType : null;
    }
}

