/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.aop.support.annotation.AnnotationMethodMatcher;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.aop.MessagePublishingInterceptor;
import org.springframework.integration.aop.MethodAnnotationPublisherMetadataSource;
import org.springframework.util.Assert;

public class PublisherAnnotationAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final MessagePublishingInterceptor interceptor;
    private final Pointcut pointcut;

    public PublisherAnnotationAdvisor() {
        this(Publisher.class);
    }

    @SafeVarargs
    public PublisherAnnotationAdvisor(Class<? extends Annotation> ... publisherAnnotationTypes) {
        MethodAnnotationPublisherMetadataSource metadataSource = new MethodAnnotationPublisherMetadataSource(Arrays.stream(publisherAnnotationTypes).collect(Collectors.toSet()));
        this.interceptor = new MessagePublishingInterceptor(metadataSource);
        this.pointcut = PublisherAnnotationAdvisor.buildPointcut(publisherAnnotationTypes);
    }

    public void setDefaultChannelName(String defaultChannelName) {
        this.interceptor.setDefaultChannelName(defaultChannelName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.interceptor.setBeanFactory(beanFactory);
    }

    public Advice getAdvice() {
        return this.interceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    private static Pointcut buildPointcut(Class<? extends Annotation>[] publisherAnnotationTypes) {
        ComposablePointcut result = null;
        for (Class<? extends Annotation> publisherAnnotationType : publisherAnnotationTypes) {
            MetaAnnotationMatchingPointcut cpc = new MetaAnnotationMatchingPointcut(publisherAnnotationType, true);
            MetaAnnotationMatchingPointcut mpc = new MetaAnnotationMatchingPointcut(null, publisherAnnotationType);
            if (result == null) {
                result = new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc);
                continue;
            }
            result.union((Pointcut)cpc).union((Pointcut)mpc);
        }
        return result;
    }

    private static final class MetaAnnotationMethodMatcher
    extends AnnotationMethodMatcher {
        private final Class<? extends Annotation> annotationType;

        MetaAnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
            super(annotationType);
            this.annotationType = annotationType;
        }

        public boolean matches(Method method, Class<?> targetClass) {
            if (AnnotationUtils.getAnnotation((Method)method, this.annotationType) != null) {
                return true;
            }
            Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
            return !specificMethod.equals(method) && AnnotationUtils.getAnnotation((Method)specificMethod, this.annotationType) != null;
        }
    }

    private static final class MetaAnnotationMatchingPointcut
    implements Pointcut {
        private final ClassFilter classFilter;
        private final MethodMatcher methodMatcher;

        MetaAnnotationMatchingPointcut(Class<? extends Annotation> classAnnotationType, boolean checkInherited) {
            this.classFilter = new AnnotationClassFilter(classAnnotationType, checkInherited);
            this.methodMatcher = MethodMatcher.TRUE;
        }

        MetaAnnotationMatchingPointcut(Class<? extends Annotation> classAnnotationType, Class<? extends Annotation> methodAnnotationType) {
            Assert.isTrue((classAnnotationType != null || methodAnnotationType != null ? 1 : 0) != 0, (String)"Either Class annotation type or Method annotation type needs to be specified (or both)");
            this.classFilter = classAnnotationType != null ? new AnnotationClassFilter(classAnnotationType) : ClassFilter.TRUE;
            this.methodMatcher = methodAnnotationType != null ? new MetaAnnotationMethodMatcher(methodAnnotationType) : MethodMatcher.TRUE;
        }

        public ClassFilter getClassFilter() {
            return this.classFilter;
        }

        public MethodMatcher getMethodMatcher() {
            return this.methodMatcher;
        }
    }
}

