/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class JdbcExecutionContextDao
extends AbstractJdbcBatchMetadataDao
implements ExecutionContextDao {
    private static final String FIND_JOB_EXECUTION_CONTEXT = "SELECT SHORT_CONTEXT, SERIALIZED_CONTEXT FROM %PREFIX%JOB_EXECUTION_CONTEXT WHERE JOB_EXECUTION_ID = ?";
    private static final String INSERT_JOB_EXECUTION_CONTEXT = "INSERT INTO %PREFIX%JOB_EXECUTION_CONTEXT (SHORT_CONTEXT, SERIALIZED_CONTEXT, JOB_EXECUTION_ID) VALUES(?, ?, ?)";
    private static final String UPDATE_JOB_EXECUTION_CONTEXT = "UPDATE %PREFIX%JOB_EXECUTION_CONTEXT SET SHORT_CONTEXT = ?, SERIALIZED_CONTEXT = ? WHERE JOB_EXECUTION_ID = ?";
    private static final String FIND_STEP_EXECUTION_CONTEXT = "SELECT SHORT_CONTEXT, SERIALIZED_CONTEXT FROM %PREFIX%STEP_EXECUTION_CONTEXT WHERE STEP_EXECUTION_ID = ?";
    private static final String INSERT_STEP_EXECUTION_CONTEXT = "INSERT INTO %PREFIX%STEP_EXECUTION_CONTEXT (SHORT_CONTEXT, SERIALIZED_CONTEXT, STEP_EXECUTION_ID) VALUES(?, ?, ?)";
    private static final String UPDATE_STEP_EXECUTION_CONTEXT = "UPDATE %PREFIX%STEP_EXECUTION_CONTEXT SET SHORT_CONTEXT = ?, SERIALIZED_CONTEXT = ? WHERE STEP_EXECUTION_ID = ?";
    private static final int DEFAULT_MAX_VARCHAR_LENGTH = 2500;
    private int shortContextLength = 2500;
    private LobHandler lobHandler = new DefaultLobHandler();
    private ExecutionContextSerializer serializer;

    public void setSerializer(ExecutionContextSerializer serializer) {
        Assert.notNull((Object)serializer, (String)"Serializer must not be null");
        this.serializer = serializer;
    }

    public void setShortContextLength(int shortContextLength) {
        this.shortContextLength = shortContextLength;
    }

    @Override
    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        List results = this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTION_CONTEXT), (RowMapper)new ExecutionContextRowMapper(), new Object[]{executionId});
        if (results.size() > 0) {
            return (ExecutionContext)results.get(0);
        }
        return new ExecutionContext();
    }

    @Override
    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        List results = this.getJdbcTemplate().query(this.getQuery(FIND_STEP_EXECUTION_CONTEXT), (RowMapper)new ExecutionContextRowMapper(), new Object[]{executionId});
        if (results.size() > 0) {
            return (ExecutionContext)results.get(0);
        }
        return new ExecutionContext();
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, UPDATE_JOB_EXECUTION_CONTEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            Long executionId = stepExecution.getId();
            ExecutionContext executionContext = stepExecution.getExecutionContext();
            Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
            Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
            String serializedContext = this.serializeContext(executionContext);
            this.persistSerializedContext(executionId, serializedContext, UPDATE_STEP_EXECUTION_CONTEXT);
        }
    }

    @Override
    public void saveExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, INSERT_JOB_EXECUTION_CONTEXT);
    }

    @Override
    public void saveExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.persistSerializedContext(executionId, serializedContext, INSERT_STEP_EXECUTION_CONTEXT);
    }

    @Override
    public void saveExecutionContexts(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save an null collection of step executions");
        HashMap<Long, String> serializedContexts = new HashMap<Long, String>(stepExecutions.size());
        for (StepExecution stepExecution : stepExecutions) {
            Long executionId = stepExecution.getId();
            ExecutionContext executionContext = stepExecution.getExecutionContext();
            Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
            Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
            serializedContexts.put(executionId, this.serializeContext(executionContext));
        }
        this.persistSerializedContexts(serializedContexts, INSERT_STEP_EXECUTION_CONTEXT);
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.serializer != null ? 1 : 0) != 0, (String)"ExecutionContextSerializer is required");
    }

    private void persistSerializedContext(final Long executionId, String serializedContext, String sql) {
        String longContext;
        String shortContext;
        if (serializedContext.length() > this.shortContextLength) {
            shortContext = serializedContext.substring(0, this.shortContextLength - 8) + " ...";
            longContext = serializedContext;
        } else {
            shortContext = serializedContext;
            longContext = null;
        }
        this.getJdbcTemplate().update(this.getQuery(sql), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setString(1, shortContext);
                if (longContext != null) {
                    JdbcExecutionContextDao.this.lobHandler.getLobCreator().setClobAsString(ps, 2, longContext);
                } else {
                    ps.setNull(2, JdbcExecutionContextDao.this.getClobTypeToUse());
                }
                ps.setLong(3, executionId);
            }
        });
    }

    private void persistSerializedContexts(final Map<Long, String> serializedContexts, String sql) {
        if (!serializedContexts.isEmpty()) {
            final Iterator<Long> executionIdIterator = serializedContexts.keySet().iterator();
            this.getJdbcTemplate().batchUpdate(this.getQuery(sql), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    String longContext;
                    String shortContext;
                    Long executionId = (Long)executionIdIterator.next();
                    String serializedContext = (String)serializedContexts.get(executionId);
                    if (serializedContext.length() > JdbcExecutionContextDao.this.shortContextLength) {
                        shortContext = serializedContext.substring(0, JdbcExecutionContextDao.this.shortContextLength - 8) + " ...";
                        longContext = serializedContext;
                    } else {
                        shortContext = serializedContext;
                        longContext = null;
                    }
                    ps.setString(1, shortContext);
                    if (longContext != null) {
                        JdbcExecutionContextDao.this.lobHandler.getLobCreator().setClobAsString(ps, 2, longContext);
                    } else {
                        ps.setNull(2, JdbcExecutionContextDao.this.getClobTypeToUse());
                    }
                    ps.setLong(3, executionId);
                }

                public int getBatchSize() {
                    return serializedContexts.size();
                }
            });
        }
    }

    private String serializeContext(ExecutionContext ctx) {
        HashMap m = new HashMap();
        for (Map.Entry me : ctx.entrySet()) {
            m.put(me.getKey(), me.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String results = "";
        try {
            this.serializer.serialize(m, out);
            results = new String(out.toByteArray(), "ISO-8859-1");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not serialize the execution context", ioe);
        }
        return results;
    }

    private class ExecutionContextRowMapper
    implements RowMapper<ExecutionContext> {
        private ExecutionContextRowMapper() {
        }

        public ExecutionContext mapRow(ResultSet rs, int i) throws SQLException {
            Map map;
            ExecutionContext executionContext = new ExecutionContext();
            String serializedContext = rs.getString("SERIALIZED_CONTEXT");
            if (serializedContext == null) {
                serializedContext = rs.getString("SHORT_CONTEXT");
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(serializedContext.getBytes("ISO-8859-1"));
                map = (Map)JdbcExecutionContextDao.this.serializer.deserialize(in);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to deserialize the execution context", ioe);
            }
            for (Map.Entry entry : map.entrySet()) {
                executionContext.put((String)entry.getKey(), entry.getValue());
            }
            return executionContext;
        }
    }
}

