/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.support.MethodInvoker;

public class MethodInvokerMethodInterceptor
implements MethodInterceptor {
    private final Map<String, Set<MethodInvoker>> invokerMap;
    private final boolean ordered;

    public MethodInvokerMethodInterceptor(Map<String, Set<MethodInvoker>> invokerMap) {
        this(invokerMap, false);
    }

    public MethodInvokerMethodInterceptor(Map<String, Set<MethodInvoker>> invokerMap, boolean ordered) {
        this.ordered = ordered;
        this.invokerMap = invokerMap;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (this.ordered && methodName.equals("getOrder")) {
            return invocation.proceed();
        }
        Set<MethodInvoker> invokers = this.invokerMap.get(methodName);
        if (invokers == null) {
            return null;
        }
        ExitStatus status = null;
        for (MethodInvoker invoker : invokers) {
            Object retVal = invoker.invokeMethod(invocation.getArguments());
            if (!(retVal instanceof ExitStatus)) continue;
            if (status != null) {
                status = status.and((ExitStatus)retVal);
                continue;
            }
            status = (ExitStatus)retVal;
        }
        return status;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodInvokerMethodInterceptor)) {
            return false;
        }
        MethodInvokerMethodInterceptor other = (MethodInvokerMethodInterceptor)obj;
        return this.invokerMap.equals(other.invokerMap);
    }

    public int hashCode() {
        return this.invokerMap.hashCode();
    }
}

