/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.api.chunk.listener.ChunkListener;
import javax.batch.api.chunk.listener.ItemProcessListener;
import javax.batch.api.chunk.listener.ItemReadListener;
import javax.batch.api.chunk.listener.ItemWriteListener;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.api.listener.StepListener;
import org.springframework.batch.core.listener.ListenerMetaData;

public enum JsrStepListenerMetaData implements ListenerMetaData
{
    BEFORE_STEP("beforeStep", "jsr-before-step", StepListener.class, new Class[0]),
    AFTER_STEP("afterStep", "jsr-after-step", StepListener.class, new Class[0]),
    BEFORE_CHUNK("beforeChunk", "jsr-before-chunk", ChunkListener.class, new Class[0]),
    AFTER_CHUNK("afterChunk", "jsr-after-chunk", ChunkListener.class, new Class[0]),
    AFTER_CHUNK_ERROR("onError", "jsr-after-chunk-error", ChunkListener.class, Exception.class),
    BEFORE_READ("beforeRead", "jsr-before-read", ItemReadListener.class, new Class[0]),
    AFTER_READ("afterRead", "jsr-after-read", ItemReadListener.class, Object.class),
    AFTER_READ_ERROR("onReadError", "jsr-after-read-error", ItemReadListener.class, Exception.class),
    BEFORE_PROCESS("beforeProcess", "jsr-before-process", ItemProcessListener.class, Object.class),
    AFTER_PROCESS("afterProcess", "jsr-after-process", ItemProcessListener.class, Object.class, Object.class),
    AFTER_PROCESS_ERROR("onProcessError", "jsr-after-process-error", ItemProcessListener.class, Object.class, Exception.class),
    BEFORE_WRITE("beforeWrite", "jsr-before-write", ItemWriteListener.class, List.class),
    AFTER_WRITE("afterWrite", "jsr-after-write", ItemWriteListener.class, List.class),
    AFTER_WRITE_ERROR("onWriteError", "jsr-after-write-error", ItemWriteListener.class, List.class, Exception.class),
    SKIP_READ("onSkipReadItem", "jsr-skip-read", SkipReadListener.class, Exception.class),
    SKIP_PROCESS("onSkipProcessItem", "jsr-skip-process", SkipProcessListener.class, Object.class, Exception.class),
    SKIP_WRITE("onSkipWriteItem", "jsr-skip-write", SkipWriteListener.class, List.class, Exception.class),
    RETRY_READ("onRetryReadException", "jsr-retry-read", RetryReadListener.class, Exception.class),
    RETRY_PROCESS("onRetryProcessException", "jsr-retry-process", RetryProcessListener.class, Object.class, Exception.class),
    RETRY_WRITE("onRetryWriteException", "jsr-retry-write", RetryWriteListener.class, List.class, Exception.class);

    private final String methodName;
    private final String propertyName;
    private final Class<?> listenerInterface;
    private static final Map<String, JsrStepListenerMetaData> propertyMap;
    private final Class<?>[] paramTypes;

    private JsrStepListenerMetaData(String methodName, String propertyName, Class<?> listenerInterface, Class<?> ... paramTypes) {
        this.propertyName = propertyName;
        this.methodName = methodName;
        this.listenerInterface = listenerInterface;
        this.paramTypes = paramTypes;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return null;
    }

    @Override
    public Class<?> getListenerInterface() {
        return this.listenerInterface;
    }

    @Override
    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public static JsrStepListenerMetaData fromPropertyName(String propertyName) {
        return propertyMap.get(propertyName);
    }

    static {
        propertyMap = new HashMap<String, JsrStepListenerMetaData>();
        for (JsrStepListenerMetaData metaData : JsrStepListenerMetaData.values()) {
            propertyMap.put(metaData.getPropertyName(), metaData);
        }
    }
}

