/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.StepLocator;

public class SimpleJob
extends AbstractJob {
    private List<Step> steps = new ArrayList<Step>();

    public SimpleJob() {
        this(null);
    }

    public SimpleJob(String name) {
        super(name);
    }

    public void setSteps(List<Step> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    @Override
    public Collection<String> getStepNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Step step : this.steps) {
            names.add(step.getName());
            if (!(step instanceof StepLocator)) continue;
            names.addAll(((StepLocator)((Object)step)).getStepNames());
        }
        return names;
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    @Override
    public Step getStep(String stepName) {
        for (Step step : this.steps) {
            Step result;
            if (step.getName().equals(stepName)) {
                return step;
            }
            if (!(step instanceof StepLocator) || (result = ((StepLocator)((Object)step)).getStep(stepName)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected void doExecute(JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        Step step;
        StepExecution stepExecution = null;
        Iterator<Step> iterator = this.steps.iterator();
        while (iterator.hasNext() && (stepExecution = this.handleStep(step = iterator.next(), execution)).getStatus() == BatchStatus.COMPLETED) {
        }
        if (stepExecution != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Upgrading JobExecution status: " + stepExecution));
            }
            execution.upgradeStatus(stepExecution.getStatus());
            execution.setExitStatus(stepExecution.getExitStatus());
        }
    }
}

