/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import java.util.Collection;
import org.springframework.batch.core.configuration.annotation.AbstractBatchConfiguration;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.AutomaticJobRegistrar;
import org.springframework.batch.core.configuration.support.DefaultJobLoader;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ModularBatchConfiguration
extends AbstractBatchConfiguration {
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private Collection<BatchConfigurer> configurers;
    private AutomaticJobRegistrar registrar = new AutomaticJobRegistrar();

    @Override
    @Bean
    public JobRepository jobRepository() throws Exception {
        return this.getConfigurer(this.configurers).getJobRepository();
    }

    @Override
    @Bean
    public JobLauncher jobLauncher() throws Exception {
        return this.getConfigurer(this.configurers).getJobLauncher();
    }

    @Override
    @Bean
    public PlatformTransactionManager transactionManager() throws Exception {
        return this.getConfigurer(this.configurers).getTransactionManager();
    }

    @Override
    @Bean
    public JobExplorer jobExplorer() throws Exception {
        return this.getConfigurer(this.configurers).getJobExplorer();
    }

    @Bean
    public AutomaticJobRegistrar jobRegistrar() throws Exception {
        this.registrar.setJobLoader(new DefaultJobLoader(this.jobRegistry()));
        for (ApplicationContextFactory factory : this.context.getBeansOfType(ApplicationContextFactory.class).values()) {
            this.registrar.addApplicationContextFactory(factory);
        }
        return this.registrar;
    }
}

