/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.HashMap;
import org.springframework.batch.core.jsr.configuration.support.JsrAutowiredAnnotationBeanPostProcessor;
import org.springframework.batch.core.jsr.configuration.support.ThreadLocalClassloaderBeanPostProcessor;
import org.springframework.batch.core.jsr.configuration.xml.JsrNamespacePostProcessor;
import org.springframework.batch.core.jsr.launch.support.BatchPropertyBeanPostProcessor;
import org.springframework.batch.core.jsr.partition.support.JsrBeanScopeBeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;

class JsrNamespaceUtils {
    private static final String JOB_PROPERTIES_BEAN_NAME = "jobProperties";
    private static final String BATCH_PROPERTY_POST_PROCESSOR_BEAN_NAME = "batchPropertyPostProcessor";
    private static final String THREAD_LOCAL_CLASS_LOADER_BEAN_POST_PROCESSOR_BEAN_NAME = "threadLocalClassloaderBeanPostProcessor";
    private static final String BEAN_SCOPE_POST_PROCESSOR_BEAN_NAME = "beanScopeBeanPostProcessor";
    private static final String BATCH_PROPERTY_CONTEXT_BEAN_CLASS_NAME = "org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext";
    private static final String BATCH_PROPERTY_CONTEXT_BEAN_NAME = "batchPropertyContext";
    private static final String JSR_NAMESPACE_POST_PROCESSOR = "jsrNamespacePostProcessor";

    JsrNamespaceUtils() {
    }

    static void autoregisterJsrBeansForNamespace(ParserContext parserContext) {
        JsrNamespaceUtils.autoRegisterJobProperties(parserContext);
        JsrNamespaceUtils.autoRegisterBatchPostProcessor(parserContext);
        JsrNamespaceUtils.autoRegisterJsrAutowiredAnnotationBeanPostProcessor(parserContext);
        JsrNamespaceUtils.autoRegisterThreadLocalClassloaderBeanPostProcessor(parserContext);
        JsrNamespaceUtils.autoRegisterBeanScopeBeanFactoryPostProcessor(parserContext);
        JsrNamespaceUtils.autoRegisterBatchPropertyContext(parserContext);
        JsrNamespaceUtils.autoRegisterNamespacePostProcessor(parserContext);
    }

    private static void autoRegisterNamespacePostProcessor(ParserContext parserContext) {
        JsrNamespaceUtils.registerPostProcessor(parserContext, JsrNamespacePostProcessor.class, 2, JSR_NAMESPACE_POST_PROCESSOR);
    }

    private static void autoRegisterBeanScopeBeanFactoryPostProcessor(ParserContext parserContext) {
        JsrNamespaceUtils.registerPostProcessor(parserContext, JsrBeanScopeBeanFactoryPostProcessor.class, 2, BEAN_SCOPE_POST_PROCESSOR_BEAN_NAME);
    }

    private static void autoRegisterBatchPostProcessor(ParserContext parserContext) {
        JsrNamespaceUtils.registerPostProcessor(parserContext, BatchPropertyBeanPostProcessor.class, 2, BATCH_PROPERTY_POST_PROCESSOR_BEAN_NAME);
    }

    private static void autoRegisterJsrAutowiredAnnotationBeanPostProcessor(ParserContext parserContext) {
        JsrNamespaceUtils.registerPostProcessor(parserContext, JsrAutowiredAnnotationBeanPostProcessor.class, 2, "org.springframework.context.annotation.internalAutowiredAnnotationProcessor");
    }

    private static void autoRegisterThreadLocalClassloaderBeanPostProcessor(ParserContext parserContext) {
        JsrNamespaceUtils.registerPostProcessor(parserContext, ThreadLocalClassloaderBeanPostProcessor.class, 2, THREAD_LOCAL_CLASS_LOADER_BEAN_POST_PROCESSOR_BEAN_NAME);
    }

    private static void registerPostProcessor(ParserContext parserContext, Class<?> clazz, int role, String beanName) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        beanDefinition.setRole(role);
        parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private static void autoRegisterJobProperties(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition(JOB_PROPERTIES_BEAN_NAME)) {
            AbstractBeanDefinition jobPropertiesBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(HashMap.class).getBeanDefinition();
            jobPropertiesBeanDefinition.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(JOB_PROPERTIES_BEAN_NAME, (BeanDefinition)jobPropertiesBeanDefinition);
        }
    }

    private static void autoRegisterBatchPropertyContext(ParserContext parserContext) {
        if (!parserContext.getRegistry().containsBeanDefinition(BATCH_PROPERTY_CONTEXT_BEAN_NAME)) {
            AbstractBeanDefinition batchPropertyContextBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)BATCH_PROPERTY_CONTEXT_BEAN_CLASS_NAME).getBeanDefinition();
            batchPropertyContextBeanDefinition.setRole(2);
            parserContext.getRegistry().registerBeanDefinition(BATCH_PROPERTY_CONTEXT_BEAN_NAME, (BeanDefinition)batchPropertyContextBeanDefinition);
        }
    }
}

