/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.EntityCollection;
import com.splunk.Password;
import com.splunk.Service;

public class PasswordCollection
extends EntityCollection<Password> {
    PasswordCollection(Service service) {
        super(service, service.passwordEndPoint, Password.class);
    }

    PasswordCollection(Service service, Args args) {
        super(service, service.passwordEndPoint, Password.class, args);
    }

    public Password create(String name, String password) {
        Args args = new Args("password", password);
        return (Password)this.create(name, args);
    }

    public Password create(String name, String password, String realm) {
        Args args = new Args();
        args.put("password", password);
        args.put("realm", realm);
        return (Password)this.create(name, args);
    }

    public Password get(String realm, String name) {
        return (Password)super.get(String.format("%s:%s:", realm, name));
    }

    @Override
    public Password get(Object key) {
        if (key instanceof String && !((String)key).contains(":")) {
            return this.getByUsername((String)key);
        }
        return (Password)super.get(key);
    }

    public Password remove(String realm, String name) {
        return (Password)super.remove(String.format("%s:%s:", realm, name));
    }

    @Override
    public Password remove(String key) {
        if (!key.contains(":")) {
            Password password = this.getByUsername(key);
            this.validate();
            if (password == null) {
                return null;
            }
            password.remove();
            this.invalidate();
            return password;
        }
        return (Password)super.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String && !((String)key).contains(":")) {
            return this.getByUsername((String)key) != null;
        }
        return super.containsKey(key);
    }

    private Password getByUsername(String name) {
        for (Password password : this.values()) {
            if (!password.getUsername().equals(name)) continue;
            return password;
        }
        return null;
    }
}

