/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Entity;
import com.splunk.ResourceCollection;
import com.splunk.Service;
import com.splunk.SplunkException;
import com.splunk.Util;
import java.util.LinkedList;
import java.util.Map;

public class EntityCollection<T extends Entity>
extends ResourceCollection<T> {
    EntityCollection(Service service, String path) {
        super(service, path, Entity.class);
    }

    EntityCollection(Service service, String path, Args args) {
        super(service, path, Entity.class, args);
    }

    EntityCollection(Service service, String path, Class itemClass) {
        super(service, path, itemClass);
    }

    public EntityCollection(Service service, String path, Class itemClass, Args args) {
        super(service, path, itemClass, args);
    }

    public T create(String name) {
        return this.create(name, null);
    }

    public T create(String name, Map args) {
        args = Args.create(args).add("name", name);
        this.service.post(this.path, args);
        this.invalidate();
        return (T)((Entity)this.get(name));
    }

    public T remove(String key) {
        this.validate();
        if (!this.containsKey(key)) {
            return null;
        }
        LinkedList entities = (LinkedList)this.items.get(key);
        if (entities != null && entities.size() > 1) {
            throw new SplunkException(3, "Key has multiple values, specify a namespace");
        }
        if (entities == null) {
            return null;
        }
        Entity entity = (Entity)entities.get(0);
        entity.remove();
        this.invalidate();
        return (T)entity;
    }

    public T remove(String key, Args namespace) {
        Util.ensureNamespaceIsExact(namespace);
        this.validate();
        if (!this.containsKey(key)) {
            return null;
        }
        LinkedList entities = (LinkedList)this.items.get(key);
        String pathMatcher = this.service.fullpath("", namespace);
        if (entities == null || entities.size() == 0) {
            return null;
        }
        for (Entity entity : entities) {
            if (!entity.path.startsWith(pathMatcher)) continue;
            entity.remove();
            this.invalidate();
            return (T)entity;
        }
        return null;
    }
}

